/* wmy2k.c - Clock that countdowns to y2k
 * Time 'til the other boxes will bug...
 *
 *  Copyright (c) 1999 Hadess
 *  Copyright (c) 1999 Bishop
 *  Copytight (c) 1997, 1998 Martijn Pieterse and Antoine Nulle
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

#include <time.h>
#include <dockapp.h>
#include <unistd.h>
#include <wmy2k-master.xpm>
#include <wmy2k-numbers.xpm>

char *displayName = "";
GC gc;
Pixmap pixmap, mask;
Pixmap pixnum, masknum;

static DAProgramOption options[] = {
    {"-display", NULL, "display to use", DOString, False, {&displayName} }
};

void copyXPMArea(int x, int y, int sx, int sy, int dx, int dy) {
XCopyArea(DADisplay, pixnum, pixmap, gc, x, y, sx, sy, dx, dy);
}


void DrawTime(int hr, int min, int sec) {

   char temp[16];
   char *p = temp;
   int i,j,k=1;

   sprintf(temp, "%02d:%02d:%02d ", hr>1 ?hr-1:hr, min, sec);

   for (i=0; i<3; i++) {
      for (j=0; j<2; j++) {
	 copyXPMArea((*p-'0')*7 + 1, 0, 8, 13, k, 2);
	 k += 7;
	 p++;
      }
      if (*p == ':') {
	 copyXPMArea(71, 0, 5, 13, k, 2);
	 k += 4;
	 p++;
      }
   }
}


void DrawDate(int dtg) {

   char temp[16];
   char *p = temp;
   int i,k;

   sprintf(temp, "%06d", dtg);
   k = 10;
   for (i=0; i<6; i++) {
      copyXPMArea((*p-'0')*7 + 1, 0, 8, 13, k, 40);
      k += 7;
      p++;
   }
}

int
main(int argc, char **argv)
{
    unsigned height, width;

    struct tm *time_struct;
    struct tm old_time_struct;
    long starttime;
    long curtime;
    long targettime;
    long difftime;
    long nexttime;

    int dayss;
    int hours;
    int mins;
    int secs;
    

    DAParseArguments(argc, argv, options,
		     sizeof(options)/sizeof(DAProgramOption),
		     "Countdown to y2k", "wmy2k 2.0 beta1");

    DAInitialize(displayName, "WMy2k", 56, 56, argc, argv);

    DAMakePixmapFromData(wmy2k_master_xpm, &pixmap, &mask, &height, &width);
    DASetPixmap(pixmap);
    DAMakePixmapFromData(wmy2k_numbers_xpm, &pixnum, &masknum, &height, &width);
    gc = DefaultGC(DADisplay, DefaultScreen(DADisplay));

    starttime = time(0);
    nexttime = starttime + 1;

    curtime = time(0);
    time_struct = localtime(&curtime);
    
    DAShow();

    while (1) {
	XEvent ev;
	DASetPixmap(pixmap);
	
	curtime = time(0);
	targettime= 946702800;
	difftime = targettime - curtime;
	dayss=difftime/86400;
	hours=(difftime%86400)/3600;
	mins=(difftime%3600)/60;
	secs=difftime%60;
	
	old_time_struct = *time_struct;
	time_struct = localtime(&curtime);

	if (curtime >= starttime) {
	   DrawTime(hours, mins, secs);
	   DrawDate(dayss);
	   DASetPixmap(pixmap);
	}

	
	/* handle all pending X events */
	while (XPending(DADisplay)) {
	    XNextEvent(DADisplay, &ev);
	    DAProcessEvent(&ev);
	}
	/* Sleep 0.3 seconds */
	usleep(300000L);
    }

    return 0;
}
