/* WMVSMWin.h - Window Maker Visual Sound Monitor Window(GUI)
 *
 *  wmvsm Window Maker Visual Sound Monitor
 * 
 *  Copyright (c) 1998-1999 Motoyasu Yamanaka
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	_H_WMVSMWIN_
#define	_H_WMVSMWIN_

#include	<stdio.h>
#include	<X11/Xlib.h>
#include	<X11/Xutil.h>

#include	"OptMgr.h"
#include	"SoundDev.h"
#include	"FFT.h"

#define	NAME	"wmvsm"
#define	CLASS	"WMVSM"

#define	CBUTTON	(1L<<0)
#define	STOP	(1L<<1)

#define	HIGH	0	/* OFF */
#define	LOW	1	/* ON */

typedef	struct {
	Display	*d;
	Window	w,
		icon,
		*activ;
	Atom	deleteAtom;
	Pixmap	fore,
		roof,
		work,
		stop,
		mask,
		tile,
		splight,
		vulight,
		button;
	GC	gc;
	unsigned int	buttonmgr;
} WINMGR;

extern	int	wmvsm_init(OPTMGR *);
extern	void	wmvsm_exit(void);
extern	int	wmvsm_run(OPTMGR *);

#endif	/* _H_WMVSMWIN */
