/* SoundDev.h - DSP, MIXER device
 *
 *  wmvsm Window Maker Visual Sound Monitor
 * 
 *  Copyright (c) 1998-1999 Motoyasu Yamanaka
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	_H_SOUNDDEV_
#define	_H_SOUNDDEV_

#include	<linux/soundcard.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<sys/ioctl.h>
#include	<fcntl.h>
#include	<unistd.h>

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	"OptMgr.h"

#define	WMVSM_BUFSIZ	1024

typedef	struct	{
	unsigned char	buffer[WMVSM_BUFSIZ * 2];	/* sampling buffer */
	int	size,				/* buffer size */
		current_size;			/* current buffer size */
} RAWDAT;

typedef	struct {
	int	d;	/* sound device file descriptor */
	RAWDAT	raw;
} SOUND_DEV_MGR;

extern	int	sd_init(SOUND_DEV_MGR *const, DEVOPT *const);
#if	__NO_DEV
extern	int	sd_init2(SOUND_DEV_MGR *const, const char *const);
#endif	/* __NO_DEV */
extern	int	sd_get_rawdata(SOUND_DEV_MGR *const, void *const, const int);
extern	int	sd_split_buffer(void *const, int, void *const, void *const, const int);
extern	void	sd_flush(SOUND_DEV_MGR *const);
extern	void	sd_stop(SOUND_DEV_MGR *const);
extern	int	sd_restart(SOUND_DEV_MGR *const, DEVOPT *const);
extern	int	sd_mix_igain(SOUND_DEV_MGR *const, const int);

#endif	/* _H_SOUNDDEV_ */
