/* OptMgr.h - Option analyze
 *
 *  wmvsm Window Maker Visual Sound Monitor
 * 
 *  Copyright (c) 1998-1999 Motoyasu Yamanaka
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	_H_OPTMGR_
#define	_H_OPTMGR_

#include	<stdio.h>
#include	<getopt.h>

#define	VERSION	"0.39b"
#define	DESIGN_BY	"Copyright (C) 1998 Motoyasu Yamanaka\n\n"\
			"e-mail: yamanaka@po1.kikimimi.ne.jp\n"\
			"URL: http://www.geocities.co.jp/"\
			"SiliconValley-PaloAlto/8813/wmvsm\n"

/* default dsp device */
#define	DEV	"/dev/dsp"

#define	__TODO	0			
/* flag */
#define	OTHER_WM_MODE	0L	/* Other Window Manager mode(default) */
#define	SHAPE_MODE	(1L<<0) /* shape mode */
#define	DRAWN_MODE	(1L<<1) /* Window Maker mode */

/* sample size */
#define	SAMPLE_SIZE_8_BIT	8
#if	__TODO
#define	SAMPLE_SIZE_16_BIT	16
#endif	/* __TODO */

/* cannel */
#define	MONO	1
#define	STEREO	2

/* mode */
#define	MODE_SPECTRUM	0
#define	MODE_VUDISP	1
#define	MODE_SCOPE	2


typedef struct {
	int	bit,		/* sample size */
		ch,		/* channel */
  		rate,		/* sampling rate */
		dma;		/* DMA */
	char	device[128];	/* sound device */
} DEVOPT;

typedef struct {
	int	ac;
	char	**av;
	int	mode;	/* monitor mode (spectum, vu, socpe) */
	unsigned int	flag;
	char	display[128];
#if	__TODO
	char	app[128];
#endif	/* __TODO */
	DEVOPT	devopt;
} OPTMGR;

extern	void	opt_init(int, char **, OPTMGR *);
extern	void	opt_stat(OPTMGR *);

#endif	/* _H_OPTMGR_ */
