/* FFT.h - fast Fourier transformation
 *
 *  wmvsm Window Maker Visual Sound Monitor
 * 
 *  Copyright (c) 1998-1999 Motoyasu Yamanaka
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	_H_FFT_
#define	_H_FFT_

#include	<math.h>
#include	<stdlib.h>

typedef	struct {
	float	imag,
		real;
} COMPLEX;

typedef	struct {
	double 	*sin_tbl;
	int	*bit_rev;
	unsigned long	exp;
} FFTMGR;

extern	int	fft_init(unsigned long);
extern	void	fft_exit(void);
extern	void	fft(COMPLEX *const, const unsigned int);
extern	int	fft_size(void);

#endif	/* _H_FFT_ */
