#include<unistd.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<fcntl.h>
#include<ctype.h>

#include<X11/Xlib.h>
#include<X11/xpm.h>
#include<X11/extensions/shape.h>

#include "../wmgeneral/wmgeneral.h"
#include "../wmgeneral/misc.h"

#include "wmtoshiba-main.xpm"

char wmtoshiba_mask_bits[64*64];
int wmtoshiba_mask_width = 64;
int wmtoshiba_mask_height = 64;

#define FANS_ON		(1)
#define FANS_OFF	(2)

#define BUT_ON		(1)
#define BUT_OFF		(2)

#define TOSHIBA_LED_ON	(1)
#define TOSHIBA_LED_OFF	(2)

#define TOSHIBA_LED_CON	(1)
#define TOSHIBA_LED_COFF (2)

#define TOSHIBA_FAN_ON	(1)
#define TOSHIBA_FAN_OFF	(2)

#define TOSHIBA_FAN_CON	(1)
#define TOSHIBA_FAN_COFF (2)

#define TOSHIBA_STATUS	(1)
#define TOSHIBA_VERSION "0.6.7"

#define TOSHIBA_STATE	(1)

void ButtonU(int);
void ButtonD(int);
void AlwaysU(int);
void AlwaysD(int);
void toshibaAlwaysON(void);
void toshibaFanOn(void);
void toshibaFanOff(void);
int toshibaFanStatus();
int FanStatus();
int ToshibaLINE();
void SetFanONLED(int);
void SetFanOFFLED(int);
void SetFanCON(int);
void SetFanCOFF(int);
void toshibaDOCK(int, char **);
void version(void);
int	start_on;
int	start_off;
int	but_stat;
int	i,j;
int	who, stat, aon;
XEvent	Event;
int main(int argc, char *argv[])
{
	int	i;
	for(i=1; i<argc; i++)
	{
		char *arg = argv[i];
		if(*arg=='-')
		{
			switch(arg[1])
			{
				case 'v' :
					version();
					exit(0);
					break;
			}
		}
	}
	toshibaDOCK(argc, argv);
	return 0;
}







void toshibaDOCK(int argc, char **argv)
{
	createXBMfromXPM(wmtoshiba_mask_bits, wmtoshiba_main_xpm, wmtoshiba_mask_width, wmtoshiba_mask_height);

	openXwindow(argc, argv, wmtoshiba_main_xpm, wmtoshiba_mask_bits, wmtoshiba_mask_width, wmtoshiba_mask_height);

	AddMouseRegion(0, 4, 48, 31, 59);
	AddMouseRegion(1, 32, 48, 60, 59);
	AddMouseRegion(2, 39, 29, 59, 36);
	AddMouseRegion(3, 39, 37, 59, 45);
	toshibaFanStatus(TOSHIBA_STATUS);
	but_stat = -1;
	while(1)
	{
	toshibaFanStatus(TOSHIBA_STATUS);
	RedrawWindow();
	usleep(50000L); 
	while(XPending(display))
	{
		XNextEvent(display, &Event);
		switch(Event.type)
		{	
			case Expose:
				RedrawWindow();
				break;
			case DestroyNotify:
				XCloseDisplay(display);
				exit(0);
				break;
			case ButtonPress:
				i = CheckMouseRegion(Event.xbutton.x, Event.xbutton.y);
				switch(i)
				{
					case 0:
						ButtonD(BUT_ON);
						break;
					case 1:
						ButtonD(BUT_OFF);
						break;
					case 2:
						AlwaysD(FANS_ON);
						break;
					case 3:
						AlwaysD(FANS_OFF);
						break;
				}
				but_stat = i;
				RedrawWindow();
				break;

			case ButtonRelease:
				i = CheckMouseRegion(Event.xbutton.x, Event.xbutton.y);
				switch(but_stat)
				{
					case 0:
						ButtonU(BUT_ON);
						break;
					case 1:
						ButtonU(BUT_OFF);
						break;
                                        case 2:
                                                AlwaysU(FANS_ON);
                                                break;

				}
				RedrawWindow();
				
				if(but_stat >= 0)
				{
					switch(i)
					{
						case 0:
							toshibaFanOn();
							SetFanONLED(TOSHIBA_FAN_ON);
							copyXPMArea(2, 67, 32, 28, 4, 16);
							break;
						case 1:
							toshibaFanOff();
							SetFanOFFLED(TOSHIBA_FAN_OFF);
							if(aon!=1)
							{
							copyXPMArea(2, 98, 32, 28, 4, 16);
							}
							break;
						case 2:
							AlwaysU(FANS_OFF);
							aon = 0;
							break;
						case 3:
							toshibaAlwaysON();
							copyXPMArea(2, 185, 56, 7, 4, 5);
							copyXPMArea(2, 67, 32, 28, 4, 16);
							break;
					}
				}
				RedrawWindow();
				stat = toshibaFanStatus(TOSHIBA_STATUS);
				but_stat = -1;
				break;
			}
	}
/* Attempt to detect who's playing with the fan */
		if((Event.type==ButtonPress)==1)
		{
			who = 1;
		}
		else if(stat==1 && FanStatus(TOSHIBA_STATE)!=1)
		{
			who = 0;
		}
		else
		if(stat==0 && FanStatus(TOSHIBA_STATE)!=0)
		{
			who = 0;
		}
	}

}



	/* copyXPMArea(2, 174, 20, 9, 40, 15); */
	/* copyXPMArea(24, 174, 20, 9, 40, 15); */
int toshibaFanStatus(int status)
{
	if (ioperm(0xb2, 1, 1))
	{
		printf("fan: can't get I/O permissions.\n");
		exit(-1);
	}

	switch(status)
	{
		case TOSHIBA_STATUS :
                        asm ("pushl %%eax\n\t" \
                                "pushl %%ebx\n\t" \
                                "pushl %%ecx\n\t" \
                                "movw $0xfefe,%%ax\n\t" \
                                "movw $0x0004,%%bx\n\t" \
                                "movw $0x0000,%%cx\n\t" \
                                "inb $0xb2,%%al\n\t" \
                                "andw $0x0001,%%cx\n\t" \
                                "movw %%cx,%0\n\t" \
                                "popl %%ecx\n\t" \
                                "popl %%ebx\n\t" \
                                "popl %%eax\n"
                                :"=m" (status) : : "memory" );

		if(status>=0x01 && aon!=1)
		{
			if(status==0x01)
			{
				SetFanCON(TOSHIBA_FAN_CON);
			}
		}
		else
		{
			if(status==0x00 && aon!=1)
			{
				SetFanCOFF(TOSHIBA_FAN_COFF);
			}
		}
		break;
	}
	return(status);
}
/* For some reason the FanStatus(); give different results to user actions =\  */
int FanStatus(int state)
{
        if (ioperm(0xb2, 1, 1))
        {
                printf("fan: can't get I/O permissions.\n");
                exit(-1);
        }

        switch(state)
        {
                case TOSHIBA_STATE :
                        asm ("pushl %%eax\n\t" \
                                "pushl %%ebx\n\t" \
                                "pushl %%ecx\n\t" \
                                "movw $0xfefe,%%ax\n\t" \
                                "movw $0x0004,%%bx\n\t" \
                                "movw $0x0000,%%cx\n\t" \
                                "inb $0xb2,%%al\n\t" \
                                "andw $0x0001,%%cx\n\t" \
                                "movw %%cx,%0\n\t" \
                                "popl %%ecx\n\t" \
                                "popl %%ebx\n\t" \
                                "popl %%eax\n"
                                :"=m" (state) : : "memory" );
	/* lets lock the fan */
		if(aon==1 && state==0)
		{
			toshibaFanOn();
		}	
	}
        return(state);
}
void toshibaAlwaysON(void)
{
	/* This little variable is going to lock the fan :) */
	aon = 1;
}
void toshibaFanOn(void)
{
        if (ioperm(0xb2, 1, 1))
        {
                printf("fan: can't get I/O permissions.\n");
                exit(-1);
        }
                        asm ("movw $0xffff,%ax\n\t" \
                                "movw $0x0004,%bx\n\t" \
                                "movw $0x0001,%cx\n\t" \
                                "inb $0xb2,%al");

}

void toshibaFanOff(void)
{
        if (ioperm(0xb2, 1, 1))
        {
                printf("fan: can't get I/O permissions.\n");
                exit(-1);
        }
                        asm ("movw $0xffff,%ax\n\t" \
                                "movw $0x0004,%bx\n\t" \
                                "movw $0x0000,%cx\n\t" \
                                "inb $0xb2,%al");

}

void SetFanONLED(int led)
{
	if(aon!=1)
	{
		switch(led)
		{
			case TOSHIBA_FAN_ON :
				copyXPMArea(2, 129, 56, 7, 4, 5);
				break;
		}
	}
}

void SetFanOFFLED(int led)
{
	if(aon!=1)
	{
		switch(led)
		{
			case TOSHIBA_FAN_OFF :
				copyXPMArea(2, 165, 56, 7, 4, 5);
				break;
		}
	}
}
void SetFanCON(int fan)
{
        if(who==0)
        {
                copyXPMArea(24, 174, 20, 9, 40, 16);
        }

	SetFanONLED(TOSHIBA_FAN_ON);
        switch(fan)
        {
                case TOSHIBA_FAN_CON :
                        copyXPMArea(2, 67, 32, 28, 4, 16);
                        break;
        }
}

void SetFanCOFF(int fan)
{
        if(who==0)
        {
               copyXPMArea(24, 174, 20, 9, 40, 16);
        }

	SetFanOFFLED(TOSHIBA_FAN_OFF);
        switch(fan)
        {
                case TOSHIBA_FAN_COFF :
                        copyXPMArea(2, 98, 32, 28, 4, 16);
                        break;
        }
}


void ButtonU(int button)
{
	switch(button)
	{
		case BUT_ON :
			copyXPMArea(2, 138, 27, 11, 4, 48);
			break;
		case BUT_OFF :
			copyXPMArea(30, 138, 27, 11, 31, 48);
			break;
	}
}

void ButtonD(int button)
{
	switch(button)
	{
		case BUT_ON :
			copyXPMArea(2, 151, 27, 11, 4, 48);
			copyXPMArea(2, 174, 20, 9, 40, 16);
			break;
		case BUT_OFF :
			copyXPMArea(30, 151, 27, 11, 31, 48);
			copyXPMArea(2, 174, 20, 9, 40, 16);
			break;
	}
}
void AlwaysD(int fanbutton)
{
	switch(fanbutton)
	{
		case FANS_ON:
			copyXPMArea(36, 85, 21, 7, 38, 29);
			break;
		case FANS_OFF:
			copyXPMArea(36, 93, 21, 7, 38, 37);
			break;
	}
} 
void AlwaysU(int fanbutton)
{
        switch(fanbutton)
        {
                case FANS_ON:
                        copyXPMArea(36, 67, 21, 7, 38, 29);
                        break;
                case FANS_OFF:
                        copyXPMArea(36, 75, 21, 7, 38, 37);
                        break;
        }
}

void version(void)
{
	fprintf(stderr, "%s\n", TOSHIBA_VERSION);
}
	
