/* Header file for cdctl.cc                                     
   Separated from cdctl.h by Steven Cook <sven@linuxfreak.com>  
 
   Copyright 1998 Sam Hawker <shawkie@geocities.com> 
 
   This software comes with ABSOLUTELY NO WARRANTY
   This software is free software, and you are welcome to redistribute it
   under certain conditions
   See the README file for a more complete notice                        */
 

/* CD status values */
#define ssData     0
#define ssStopped  1
#define ssPlaying  2
#define ssPaused   3
#define ssNoCD     4
#define ssTrayOpen 5

/* Audio command values */
#define acStop   0
#define acPlay   1
#define acPause  2
#define acResume 3
#define acPrev   4
#define acNext   5
#define acRewd   6
#define acFFwd   7
#define acEject  8
#define acClose  9

#define tsNone      0    /* Just stop */
#define tsRepeat    1    /* Play it again */
#define tsNext      2    /* Play next track (stop at end of CD) */
#define tsRepeatCD  3    /* Play next track (start from first track if end is reached) */
#define tsRandom    4    /* Play a track at random */

class CDCtl {

public:

	CDCtl(char *dname);
	~CDCtl();
	bool openOK();
	void doAudioCommand(int cmd);
	void doStatus();
	void setTrackSelection(int ts);
	int getTrackSelection();
	char *getDevName();
	int getCDTracks();
	int getCDLen();
	int getTrackStart(int trk);
	int getTrackLen(int trk);
	bool getTrackData(int trk);
	int getStatusState();
	int getStatusTrack();
	int getStatusPosAbs();
	int getStatusPosRel();
	int getLeadout();
	unsigned long getDiscID();

private:

	int cddb_sum(int n);
	void readTOC();
	void trackinfo(struct cdrom_subchnl *subchnl);
	void play();
	void select(int trk);
	void selecttrack();

	int cdfd;
	int cdfdopen;
	char *device;
	int tracksel;
	bool tskOurPlay;

	struct CDTrack {
		int track_start;
		int track_len;
		bool track_data;
	};
 
	unsigned long cddb_discid;
	int cd_tracks;
	int cd_len;
	int leadout;
	struct CDTrack *cd_trklist;
	int status_state;
	int status_track;
	int status_pos;

};
