/* linked list implementation */

#include "wmstock.h"

/*int main() 
{ 
	ticker_struct ts;

	strcpy(ts.ticker,"BOB");
	ts.last_price=3.3;
	insert_last(ts);

	strcpy(ts.ticker,"FRE");
	ts.last_price=5.5;
	insert_last(ts);

	printf("current head: %s\n",head->ts.ticker);	
	
	delete (head);
	printf("current head: %s\n",head->ts.ticker);	
	delete (head);

	if (head) printf ("this should not appear.\n");

	return 0; 

} */

/* deletes a node in the list */
int delete (node *to_del)
{
	node *temp1,*temp2;
	
	if (!to_del) 			/*node does not exist, fail */
	{ return -1; }			

	temp1=NULL;		/*previous node*/
	temp2=to_del;		/*following node*/

	if(temp2->next!=NULL)   
        {
		temp1=temp2->next;    
		temp1->prev=temp2->prev;    
        }
        if(temp2->prev!=NULL)   
        {
		temp1=temp2->prev;    
		temp1->next=temp2->next;   
        }
        if(temp2==head)      
        {
		if(temp2->next!=NULL) 
            		head=temp2->next;
		else       
			head=NULL;
        }
        free(temp2);		/* possible bad, do I need to free the strings as well??  */
	return 1;          
}

/* inserts a new node at the end of the list */
int insert_last (struct ticker_struct temp_tick)
{
	node *tnode;
	int tret;

	if ((tnode=malloc(sizeof (node)))==NULL)
	{
		fprintf(stderr,"ll.c::insert_last - malloc failed to malloc\
		%i bytes of memory.\n",(sizeof (node)));
		exit(1);
	}
	
	tret=copy_stock_data(temp_tick,tnode);
	
	if (tret!=1)
	{
		fprintf(stderr,"ll.c::insert_last - failed to copy the stock\
		data to the new node.\n");
		return tret;
	}
	
	if (tail!=NULL)		/* list has elements in it */
	{
		tnode->prev=tail;
		tail->next=tnode;
	}
	else
	{ 			/* list is empty */
		tnode->prev=NULL;
		head=tnode;
	}

	tnode->next=NULL;
	tail=tnode;
	tail->next=NULL;

	return 1;
}

/* inserts a new node at the beginning of the list */
int insert_pre (struct ticker_struct temp_tick)
{
	node *tnode;
	int tret;

	if ((tnode=malloc(sizeof (node)))==NULL)
	{
		fprintf(stderr,"ll.c::insert_last - malloc failed to malloc\
		%i bytes of memory.\n",(sizeof (node)));
		exit(1);
	}
	
	tret=copy_stock_data(temp_tick,tnode);
	
	if (tret!=1)
	{
		fprintf(stderr,"ll.c::insert_last - failed to copy the stock\
		data to the new node.\n");
		return tret;
	}
	
	if (head!=NULL)		/* list is empty */
	{
		tnode->next=head;
		head->prev=tnode;
	}
	else 
	{
		tnode->next=NULL;
		tail=tnode;
	}

	tnode->prev=NULL;
	head=tnode;
	head->prev=NULL;

	return 1;
}

int copy_stock_data(struct ticker_struct tick, node *tnode)
{
	tnode->ts=tick;
	/*tnode->ts.ticker=strdup(tick.ticker);
        tnode->ts.company_name = strdup(tick.company_name);
        tnode->ts.last_trade_date = strdup(tick.last_trade_date);
        tnode->ts.last_trade_time =strdup(tick.last_trade_time);
        tnode->ts.change =strdup(tick.change);
        tnode->ts.percent_change =strdup(tick.percent_change); 
        tnode->ts.bid =strdup(tick.bid);
        tnode->ts.ask =strdup(tick.ask);
        tnode->ts.days_range =strdup(tick.days_range);
        tnode->ts.fifty_two_week_range =strdup(tick.fifty_two_week_range);
        tnode->ts.div_date =strdup(tick.div_date);
        tnode->ts.market_cap =strdup(tick.market_cap); */
	
	return 1;
}
