/******************************************************************************
*   WMSound	WindowMaker Sound Server	                              *
*   Copyright (C) 1998  Anthony Quinn <southgat@frontiernet.net               *
*									      *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.					      *
*									      *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*******************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <proplist.h>

#include "../lib/wmsnd.h"


extern proplist_t WMSoundDB;
char *ProgName;

int main(int argc, char **argv) {
	proplist_t style;
	ProgName = argv[0];
	
	if(argc != 2) {
	  printf("usage: %s <style file>\n\r",ProgName);
	  exit(1);
	} 
	
	wmsndLoadConfig();
	
	style = PLGetProplistWithPath(argv[1]);
	if(!style) {
          PLRelease(WMSoundDB);
	  printf("%s:could not load style file '%s'\n",ProgName,argv[1]);
          exit(1);
	}
	
	PLMergeDictionaries(WMSoundDB,style);
	PLSave(WMSoundDB,YES);
	PLRelease(WMSoundDB);
	PLRelease(style);
	return 1;
}
