/******************************************************************************
*   WMSound	WindowMaker Sound Server	                              *
*   Copyright (C) 1998  Anthony Quinn <southgat@frontiernet.net>              *
*                       William Moore <billy@mud.mind.net>		      *
*			Pascal Hofstee <daeron@shadowmere.student.utwente.nl> *
*									      *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.					      *
*									      *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*******************************************************************************/

#ifndef WMSOUND_H_
#define WMSOUND_H_

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#ifndef __FreeBSD__
#include <malloc.h>
#endif
#include <sys/stat.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <proplist.h>

#include "../lib/wmsnd.h"

#define WMSOUND_STARTUP     1000
#define WMSOUND_SHADE       WMSOUND_STARTUP + 1
#define WMSOUND_UNSHADE     WMSOUND_SHADE + 1
#define WMSOUND_MAXIMIZE    WMSOUND_UNSHADE + 1
#define WMSOUND_UNMAXIMIZE  WMSOUND_MAXIMIZE + 1
#define WMSOUND_ICONIFY     WMSOUND_UNMAXIMIZE + 1
#define WMSOUND_DEICONIFY   WMSOUND_ICONIFY + 1
#define WMSOUND_HIDE        WMSOUND_DEICONIFY + 1
#define WMSOUND_UNHIDE      WMSOUND_HIDE + 1
#define WMSOUND_APPSTART    WMSOUND_UNHIDE + 1
#define WMSOUND_APPEXIT     WMSOUND_APPSTART + 1
#define WMSOUND_USER_DEF    WMSOUND_APPEXIT + 1
#define APPNAME "WMSoundServer"

Window	   wmsndMain;
Display	   *mainDpy;
Atom	   deleteWin, _XA_WINDOWMAKER_WM_FUNCTION,protos[2];
XClassHint clsHints;
XWMHints   *wmgrHints;
u_long	   blk_pixl, wht_pixl;
int	   winCount;
Bool       blHidden;

/* Begin proto types */
int	wmsndInitDisplay (int argc, char **argv);
void	wmsndDispatchStartup ();
void	wmsndProcessEvents ();
#endif
