/******************************************************************************
*   WMSound	WindowMaker Sound Server	                              *
*   Copyright (C) 1998  Anthony Quinn <southgat@frontiernet.net>              *
*                       William Moore <billy@mud.mind.net>		      *
*			Pascal Hofstee <daeron@shadowmere.student.utwente.nl> *
*									      *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.					      *
*									      *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*******************************************************************************/

#include "wmsound.h"

int main (int argc, char *argv[]) {
    
    if (argc > 1) {
      if (strcmp(argv[1],"--hidden") == 0) {
        blHidden = True;
      }
      else {
        blHidden = False;
      }
    }
    if (wmsndInitDisplay(argc, argv) >= 0) {
	wmsndDispatchStartup();
    }
    else {
	fprintf(stderr, "WMSound Error: %s\n", "Could not initialize Display");
	exit(1);
    }
    wmsndProcessEvents();
    return 0;
}


int wmsndInitDisplay (int argc, char **argv)
{
    winCount = 0;
    mainDpy = XOpenDisplay("");
    if (!mainDpy) {
	return -1;
    }
    
    blk_pixl = BlackPixel(mainDpy, DefaultScreen(mainDpy));
    wht_pixl = WhitePixel(mainDpy, DefaultScreen(mainDpy));
    
    wmsndMain = XCreateSimpleWindow(mainDpy, DefaultRootWindow(mainDpy), 10, 10, 150, 50, wht_pixl, blk_pixl, 0);
    if (!wmsndMain) {
	return -1;
    }
    
    _XA_WINDOWMAKER_WM_FUNCTION = XInternAtom(mainDpy, "_WINDOWMAKER_WM_FUNCTION", False);
    deleteWin = XInternAtom(mainDpy, "WM_DELETE_WINDOW", False);
    
    clsHints.res_name = "wmsoundserver";
    clsHints.res_class = APPNAME;
    XSetClassHint (mainDpy, wmsndMain, &clsHints);
    
    wmgrHints = XAllocWMHints();
    if (!wmgrHints) {
	return -1;
    }
    
    wmgrHints->window_group = wmsndMain;
    wmgrHints->initial_state = WithdrawnState;
    wmgrHints->flags = WindowGroupHint|StateHint;
    
    XSetWMHints(mainDpy, wmsndMain, wmgrHints);
    
    protos[0] = _XA_WINDOWMAKER_WM_FUNCTION;
    protos[1] = deleteWin;
    
    XSetCommand(mainDpy, wmsndMain, argv, argc);
    XSetWMProtocols(mainDpy, wmsndMain, protos, 2);
    XClearWindow(mainDpy, wmsndMain);
    if (!blHidden) {
      XMapWindow(mainDpy, wmsndMain);
    }
    winCount++;
    XFree(wmgrHints);
    return 0;
}


void wmsndDispatchStartup ()
{
    XEvent SoundEvent;
    
    SoundEvent.xclient.type		= ClientMessage;
    SoundEvent.xclient.message_type	= _XA_WINDOWMAKER_WM_FUNCTION;
    SoundEvent.xclient.format		= 32;
    SoundEvent.xclient.display		= mainDpy;
    SoundEvent.xclient.window		= wmsndMain;
    SoundEvent.xclient.data.l[0]	= WMSOUND_STARTUP;
    XSendEvent(mainDpy, wmsndMain, False, NoEventMask, &SoundEvent);
    XFlush(mainDpy);
}


void wmsndProcessEvents ()
{
  XEvent event;
    
  while (winCount > 0) {
    XNextEvent(mainDpy, &event);
    switch(event.type) {
      case ClientMessage: {
        if (event.xclient.data.l[0] == deleteWin) {
          XDestroyWindow(mainDpy, event.xclient.window);
          winCount--;
	}
	if (event.xclient.message_type == _XA_WINDOWMAKER_WM_FUNCTION) {
          if (!wmsndPlayEvent(event.xclient.data.l[0])) {
            fprintf(stderr, "Error on Play Event\n");
          }
          XSync(mainDpy, True);
        }
        break;
      } /* case */
    } /*switch*/
  } /*while*/
}
