/******************************************************************************
*   WMSound     WindowMaker Sound Server                                      *
*   Copyright (C) 1999  Anthony Quinn <southgat@frontiernet.net>              *
*   			Pascal Hofstee <daeron@shadowmere.student.utwente.nl> *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*******************************************************************************/

#ifndef WMSND_H_
#define WMSND_H_

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#ifndef __FreeBSD__
#include <malloc.h>
#endif

#include <sys/stat.h>
#include <sys/types.h>
#include <sys/fcntl.h>

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <proplist.h>

/* Defines */

#define	WMSND_DEVICE		"Device"
#define	WMSND_STARTUP		"Startup"
#define	WMSND_APPSTART		"AppStart"
#define	WMSND_APPEXIT		"AppExit"
#define	WMSND_MAXIMIZE		"Maximize"
#define WMSND_UNMAXIMIZE	"UnMaximize"
#define	WMSND_ICONIFY		"Iconify"
#define	WMSND_DEICONIFY		"DeIconify"
#define	WMSND_HIDE		"Hide"
#define	WMSND_UNHIDE		"UnHide"
#define	WMSND_SHADE		"Shade"
#define WMSND_UNSHADE		"UnShade"
#define WMSND_USERDEF		"UserDefined"

#define	DEFAULTS_DIR	"/Defaults/"
#define	GSTEP_DIR	"/GNUstep"
#define	WMSOUND_DOMAIN	"WMSound"
#define WMAKER_DOMAIN	"WindowMaker"

/* Globals */

proplist_t  WMSoundDB;
Bool        WMSoundDBLoaded;
Display	    *dpy;
Window	    wmsnd;
Atom 	    _XA_WINDOWMAKER_WM_FUNCTION;

/* API */
Bool	wmsndPlaySound (char *sound_file);	/* Play through SoundServer		*/
Bool	wmsndPlaySoundCore (char *sound_file);	/* Play using core sound routines	*/
Bool	wmsndFindSoundServer (void);		/* Is the SoundServer active		*/
Bool	wmsndSendSound (void);			/* Send UserDefined sound event		*/
Bool	wmsndPlayEvent (long wsEventID);	/* Play specific SoundEvent		*/
char    *wmsndMapEventID(long wsEventID);
char	*wmsndGetSoundFile (char *plKey);
void	wmsndLoadConfig ();
void	wAbort ();

/* Core Utils Not intended to be used outside of API functions*/

proplist_t loadLocalDomain ();
Bool       makeLocalDomain ();
int        checkForFile(char *instrpath);
int        getDomainSize(char *instrpath);
char *     getLocalDefaultDomain();
char *     getGlobalDefaultDomain();
char *     expandPath(char *strpath);
Bool       copyDomain(char *insrcpath, char *indestpath, int dwsize);
Bool       makeLocalDomain();

extern proplist_t wmsndGetObjectForKey(char *defaultName);
extern void       wmsndSetObjectForKey(proplist_t object, char *defaultName);
extern void       wmsndRemoveObjectForKey(char *defaultName);
extern char       *wmsndGetStringForKey(char *defaultName);
extern proplist_t wmsndGetArrayForKey(char *defaultName);
extern proplist_t wmsndGetDictionaryForKey(char *defaultName);
extern void	  wmsndSetStringForKey(char *value, char *defaultName);
extern int        sPlayFile(char *sound_file, char *audiodev);

#endif
