/* PLFunctions.c- Functions to manipulate PropList-configurations
 * 
 *  WSoundPrefs - WMSound Server Preferences Program
 * 
 *  Copyright (c) 1999 Pascal G. Hofstee
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */


#include "wmsnd.h"

proplist_t
wmsndGetObjectForKey(char *defaultName)
{
    proplist_t object = NULL;
    proplist_t key = PLMakeString(defaultName);

    object = PLGetDictionaryEntry(WMSoundDB, key);
/*
    Don't use a Global/Local Approach in this application
    if (!object)
	object = PLGetDictionaryEntry(GlobalDB, key);
*/

    PLRelease(key);

    return object;
}


void
wmsndSetObjectForKey(proplist_t object, char *defaultName)
{
    proplist_t key = PLMakeString(defaultName);

    PLInsertDictionaryEntry(WMSoundDB, key, object);
    PLRelease(key);
}


void
wmsndRemoveObjectForKey(char *defaultName)
{
    proplist_t key = PLMakeString(defaultName);
    
    PLRemoveDictionaryEntry(WMSoundDB, key);
    
    PLRelease(key);
}


char*
wmsndGetStringForKey(char *defaultName)
{
    proplist_t val;
    
    val = wmsndGetObjectForKey(defaultName);

    if (!val)
	return NULL;

    if (!PLIsString(val))
	return NULL;

    return PLGetString(val);
}



proplist_t
wmsndGetArrayForKey(char *defaultName)
{
    proplist_t val;
    
    val = wmsndGetObjectForKey(defaultName);
    
    if (!val)
	return NULL;

    if (!PLIsArray(val))
	return NULL;

    return val;
}


proplist_t
wmsndGetDictionaryForKey(char *defaultName)
{
    proplist_t val;

    val = wmsndGetObjectForKey(defaultName);
    
    if (!val)
	return NULL;

    if (!PLIsDictionary(val))
	return NULL;

    return val;
}


void
wmsndSetStringForKey(char *value, char *defaultName)
{
    proplist_t object;

    object = PLMakeString(value);
 
    wmsndSetObjectForKey(object, defaultName);
    PLRelease(object);
}
