/******************************************************************************
*   WMSound	WindowMaker Sound Server	                              *
*   Copyright (C) 1999  Anthony Quinn <southgat@frontiernet.net>              *
*			Pascal Hofstee <daeron@shadowmere.student.utwente.nl> *
*									      *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.					      *
*									      *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*******************************************************************************/


#ifndef FORMATS_H_
#define FORMATS_H_


/* These are for RIFF wav files */
#define format_chunk 1
#define data_chunk   2

#define AUDIO_UNKNOWN_SIZE ~0

#ifdef __alpha__
    typedef u_int   dword;
#else
    #ifdef BIG_ENDIAN
	typedef u_int dword;
    #else
	typedef u_long dword;
    #endif 
#endif 

typedef u_short word;
  
typedef struct riff_typ {
    char   riff[4];
    dword riffsize;
} riff_info,*riff_info_ptr;

typedef struct wav_typ {
    dword  pcmheader;
    word   pcmfmt;
    word   channels;
    dword  sampleps;
    dword  bytesps;
    word   bytespsamp;
    word    bitsperchan;
} wavheader, *wavheader_ptr;

typedef struct au_typ {
    dword magic;
    dword hdr_size;
    dword data_size;
    dword encoding;
    dword sample_rate;
    dword channels;
} au_info, *au_info_ptr;


#endif
