/*
    config.h - Header file for the Linux sensor programs
    Copyright (c) 1997, 1998  Alexander Larsson <alla@lysator.liu.se>,
    Frodo Looijaard <frodol@dds.nl> and Philip Edelbrock <phil@netroedge.com>.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* Any user-configurable stuff which is not in the Makefile goes here. */

/* Note: Parts of this file may only be included in ONE sourcefile, 
   because we initialize variables here. This is done from main.c. Do not 
   define LM78_FULL_CONFIG elsewhere! */

#ifndef LM78_CONFIG_H
#define LM78_CONFIG_H

#ifdef LM_FULL_CONFIG

#include "main.h"
#include "lm78.h"

/* Kludge; if EXTERN==external, we can't put an initial value behind it;
   if EXTERN=static, it must be there, or we get an incompatible types
   error.
*/
#ifdef ALLINONE
EXTERN
#endif
       struct LM_Sensor_Config LM_Sensor_Config =

/* Modify this if you want to set compile-time defaults that are
   different from these defaults. 
   Please read the comments carefully: if you enter read weird values,
   you might even make the module crash your computer! */

{ 
/* A list of seven strings, which are used to label each voltage sensor.
   These labels will be used in /proc/sensors. Each label can be at
   most LABEL_LENGTH characters long (substract one because we need a
   #0 at the end). DO NOT USE EMPTY STRINGS OR WHITESPACE WITHIN STRINGS!
*/
  { "Vcore","Vcore2","+3.3V","+5V","+12V","-12V","-5V" },

/* A list of seven scaling factors for the voltage sensors. These factors
   are used to compute the real voltage from the sensed voltage: because
   an LM78 can only be fed voltages upto about 4 volts, anything above
   that is first reduced by a voltage divider (a couple of resistors). 
   These values are mentioned by the Winbond documentation. They may be
   off for your mainboard.
*/
  { 10000, 10000, 10000, 16892, 38000, -34768, -15050 },


/* A list of three strings, which are used to label each fan.
   These labels will be used in /proc/sensors. Each label can be at
   most LABEL_LENGTH characters long (substract one because we need a
   #0 at the end). DO NOT USE EMPTY STRINGS OR WHITESPACE WITHIN STRINGS!
*/
  { "Fan1","Fan2","Fan3" },

/* A list of eight strings, which are used to label each LM75.
   These labels will be used in /proc/sensors. Each label can be at
   most LABEL_LENGTH characters long (substract one because we need a
   #0 at the end). DO NOT USE EMPTY STRINGS OR WHITESPACE WITHIN STRINGS!
*/
  { "Temp-1", "Temp-2", "Temp-3", "Temp-4", 
    "Temp-5", "Temp-6", "Temp-7", "Temp-8" },

  {
/* A bitvector which determines which sensors are actually connected.
   bit 0 = in0, bit 1 = in1, etc. A zero means 'do not display in
   /proc/sensors'.
*/
   0x7f,
/* A bitvector which determines which fans are actually connected.
   bit 0 = fan1, bit 1 = fan2, etc. A zero means 'do not display in
   /proc/sensors'. Note that the LM80 does not have a third fan;
   even if bit 2 is set, the fan will not be displayed. 
*/
   0x07,

/* A one means 'VID-lines connected', a zero means 'not connected'.
   If not connected, they are not displayed in /proc/sensors.
*/
   1,

/* A one means 'Main temperature sensors connected', a zero means
   'not connected'.
*/
   1,

/* A bitvector which determines which LM75 temperature sensors are actually 
   connected. bit 0 = lm75-0, bit 1 = lm75-1, etc. A zero means 'do not
   display in /proc/sensors'. Note that if a LM75 is not detected it will
   not be displayed, even if you set its corresponding bit.
*/
    0xff
  }
};

#endif /* LM78_FULL_CONFIG */


/* The next couple of defines determine the initial values for the 
   voltage sensor limits. */

/* Please do not touch this ugly macro - it is needed as is. You can
   use it to set the Core Voltage to the VID lines output */
#define LM78_VID_CORE \
(!LM_Sensor_Present.vid?LM78_VID_CORE_DEFAULT: \
 ((LM78_Get(LM_PROBE_VID,0) <= 0)?LM78_VID_CORE_DEFAULT: \
   LM78_Get(LM_PROBE_VID,0)))

/* What to use if the VID outputs are not available */
#define LM78_VID_CORE_DEFAULT 270

/* The number of percent it may be off before we emit an alarm */
#define LM78_IN_INIT_PERCENTAGE 10

/* The voltages expected times a hundred. Note that we hardcode IN0 and
   IN1 here; this will change in the future (we will use the VID-lines
   instead). */
#define LM78_IN0_INIT_VAL    LM78_VID_CORE
#define LM78_IN1_INIT_VAL    LM78_VID_CORE
#define LM78_IN2_INIT_VAL    330
#define LM78_IN3_INIT_VAL    500
#define LM78_IN4_INIT_VAL    1200
#define LM78_IN5_INIT_VAL    -1200
#define LM78_IN6_INIT_VAL    -500

/* OK, and here we finally code the min and max limits. Feel free to 
   overrule them! Note: this is in voltages times a hundred. */
#define LM78_IN0_INIT_MIN (LM78_IN0_INIT_VAL - LM78_IN0_INIT_VAL * LM78_IN_INIT_PERCENTAGE / 100)
#define LM78_IN0_INIT_MAX (LM78_IN0_INIT_VAL + LM78_IN0_INIT_VAL * LM78_IN_INIT_PERCENTAGE / 100)
#define LM78_IN1_INIT_MIN (LM78_IN1_INIT_VAL - LM78_IN1_INIT_VAL * LM78_IN_INIT_PERCENTAGE / 100)
#define LM78_IN1_INIT_MAX (LM78_IN1_INIT_VAL + LM78_IN1_INIT_VAL * LM78_IN_INIT_PERCENTAGE / 100)
#define LM78_IN2_INIT_MIN (LM78_IN2_INIT_VAL - LM78_IN2_INIT_VAL * LM78_IN_INIT_PERCENTAGE / 100)
#define LM78_IN2_INIT_MAX (LM78_IN2_INIT_VAL + LM78_IN2_INIT_VAL * LM78_IN_INIT_PERCENTAGE / 100)
#define LM78_IN3_INIT_MIN (LM78_IN3_INIT_VAL - LM78_IN3_INIT_VAL * LM78_IN_INIT_PERCENTAGE / 100)
#define LM78_IN3_INIT_MAX (LM78_IN3_INIT_VAL + LM78_IN3_INIT_VAL * LM78_IN_INIT_PERCENTAGE / 100)
#define LM78_IN4_INIT_MIN (LM78_IN4_INIT_VAL - LM78_IN4_INIT_VAL * LM78_IN_INIT_PERCENTAGE / 100)
#define LM78_IN4_INIT_MAX (LM78_IN4_INIT_VAL + LM78_IN4_INIT_VAL * LM78_IN_INIT_PERCENTAGE / 100)
#define LM78_IN5_INIT_MIN (LM78_IN5_INIT_VAL - LM78_IN5_INIT_VAL * LM78_IN_INIT_PERCENTAGE / 100)
#define LM78_IN5_INIT_MAX (LM78_IN5_INIT_VAL + LM78_IN5_INIT_VAL * LM78_IN_INIT_PERCENTAGE / 100)
#define LM78_IN6_INIT_MIN (LM78_IN6_INIT_VAL - LM78_IN6_INIT_VAL * LM78_IN_INIT_PERCENTAGE / 100)
#define LM78_IN6_INIT_MAX (LM78_IN6_INIT_VAL + LM78_IN6_INIT_VAL * LM78_IN_INIT_PERCENTAGE / 100)

/* The initial fan divisors. Valid values: 1, 2, 4 or 8. The defaults should
   be all right. */
#define LM78_FAN1_INIT_DIV 2
#define LM78_FAN2_INIT_DIV 2
#define LM78_FAN3_INIT_DIV 2

/* The minimum fan rotations-per-minute. */
#define LM78_FAN1_INIT_MIN (1500 * (LM78_FAN1_INIT_DIV))
#define LM78_FAN2_INIT_MIN (1500 * (LM78_FAN2_INIT_DIV))
#define LM78_FAN3_INIT_MIN (1500 * (LM78_FAN3_INIT_DIV))

/* Temperature limits in degrees. */
#define LM78_TEMP_INIT_MIN 0
#define LM78_TEMP_INIT_MAX 50

/* LM75 temperature limits in degrees. Note that this is in degrees celcius
   times ten. 
   The OS is the maximum that will start triggering the alarm. It will
   continue until the temperature is back below HYST. */
#define LM75_TEMP1_INIT_OS 500
#define LM75_TEMP1_INIT_HYST 450
#define LM75_TEMP2_INIT_OS 500
#define LM75_TEMP2_INIT_HYST 450
#define LM75_TEMP3_INIT_OS 500
#define LM75_TEMP3_INIT_HYST 450
#define LM75_TEMP4_INIT_OS 500
#define LM75_TEMP4_INIT_HYST 450
#define LM75_TEMP5_INIT_OS 500
#define LM75_TEMP5_INIT_HYST 450
#define LM75_TEMP6_INIT_OS 500
#define LM75_TEMP6_INIT_HYST 450
#define LM75_TEMP7_INIT_OS 500
#define LM75_TEMP7_INIT_HYST 450
#define LM75_TEMP8_INIT_OS 500
#define LM75_TEMP8_INIT_HYST 450

#endif /* LM78_CONFIG_H */
