/*
    lmsysctl.h - Part of a Linux module for reading sensor data.
    Copyright (c) 1997, 1998  Alexander Larsson <alla@lysator.liu.se>,
    Frodo Looijaard <frodol@dds.nl> and Philip Edelbrock <phil@netroedge.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __LINUX_LM_SENSORS_H
#define __LINUX_LM_SENSORS_H

/* Here follow SYSCTL constants */

#ifdef DEV_HWMON
#define DEV_LMT DEV_HWMON
#else
#define DEV_LMT 2  /* The id of the lm_sensors directory within the
                      dev table */
#endif

/* Things within the lm_sensors (LMT) directory */

/* Notes for all string encoded values:
   Strings will get concatenated if the buffer is not long enough.
   Strings will always be terminated with a 0 character.
   Values within strings will be separated with spaces; there may be no
     whitespace within values.

   Notes for all long encoded values:
   Longs are always used, not integers!
   If the buffer is too short only a few integers will get written; but
     only whole integers are written, never parts of them.
   Integers are used instead of floats, and are scaled. The scaling factors
     are enumerated below.
*/

#define LMT_IN0 2 /* in0: min, max, current voltage, times 100 */
#define LMT_IN1 3 /* in1: min, max, current voltage, times 100 */
#define LMT_IN2 4 /* in2: min, max, current voltage, times 100 */
#define LMT_IN3 5 /* in3: min, max, current voltage, times 100 */
#define LMT_IN4 6 /* in4: min, max, current voltage, times 100 */
#define LMT_IN5 7 /* in5: min, max, current voltage, times 100 */
#define LMT_IN6 8 /* in6: min, max, current voltage, times 100 */

#define LMT_FAN1 9  /* fan0: min, current rpm */
#define LMT_FAN2 10 /* fan1: min, current rpm */
#define LMT_FAN3 11 /* fan2: min, current rpm */

#define LMT_TEMP_MB 12 /* temp_mb: min, max, current temperature */

#define LMT_VID 27 /* vid: core voltage, times 100. Unwritable! */
#define LMT_ALARM 28 /* alarm: bitvector of current alarms. Unwritable!
                        See below to access the bits */

#define LMT_TEMP_1 13 /* temp-1: os, hyst, current temp, times 10 */
#define LMT_TEMP_2 14 /* temp-2: os, hyst, current temp, times 10 */
#define LMT_TEMP_3 15 /* temp-3: os, hyst, current temp, times 10 */
#define LMT_TEMP_4 16 /* temp-4: os, hyst, current temp, times 10 */
#define LMT_TEMP_5 17 /* temp-5: os, hyst, current temp, times 10 */
#define LMT_TEMP_6 18 /* temp-6: os, hyst, current temp, times 10 */
#define LMT_TEMP_7 19 /* temp-7: os, hyst, current temp, times 10 */
#define LMT_TEMP_8 20 /* temp-8: os, hyst, current temp, times 10 */

#define LMT_IN_CONV 21 /* config-in-conv: in0, .., in6 factors, times 10000 */
#define LMT_FAN_DIV 22 /* config-fan-div: fan1, fan2, fan3 division factors */
#define LMT_PRESENT 23 /* config-present: in, fan, vid, temp, lm75 present */
#define LMT_FAN_LABELS 24 /* config-fan-labels: labels for fan1, fan2, fan3 */
#define LMT_IN_LABELS 25 /* config-in-labels: labels for in0, .., in7 */
#define LMT_TEMP_LABELS 26 /* config-temp-labels: labels for lm75-0 .. lm75-7 */


/* Bits in LMT_ALARM */

#define LMALARM_IN0 0x0001
#define LMALARM_IN1 0x0002
#define LMALARM_IN2 0x0004
#define LMALARM_IN3 0x0008
#define LMALARM_IN4 0x0010
#define LMALARM_IN5 0x0020
#define LMALARM_IN6 0x0040
#define LMALARM_FAN1 0x0080
#define LMALARM_FAN2 0x0100
#define LMALARM_FAN3 0x0200
#define LMALARM_TEMP 0x0400
#define LMALARM_LM75 0x0800
#define LMALARM_CHAS 0x1000
#define LMALARM_FIFO 0x2000
#define LMALARM_SMI  0x4000
#define LMALARM_INT  0x8000

#endif 
