//Copyright (C) 1998 John Meacham 
//john@foo.net
//
// wmscope.. scope display applet for windowmaker/afterstep

// 1/19/1999 Paul McAvoy (paulmcav@auctomation.com)
// .. added command line option for amplfication factor.



#define DEFAULTDEVICE "/dev/dsp"
#define LEDCOLOR "green"
#define BACKCOLOR "#282828"
#define SAMPLING_SPEED 8000

//these defaults can be changed by command line options.
#define WINDOWMAKER false
#define USESHAPE false
#define NAME "wmscope"
#define CLASS "WMScope"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <math.h>
#include <iostream.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#if  defined(__Linux__)
#include <linux/soundcard.h>
#elif defined(__FreeBSD__) 
#include <machine/soundcard.h>
#else 
#include <sys/soundcard.h>
#endif



#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

static Pixmap tile;
static Pixmap cover;

#include"tile.xpm"
#include"cover.xpm"

// Runtime pixmaps
static Pixmap disp;
static Pixmap dmsk;

// For command line arguments
static bool wmaker = WINDOWMAKER;
static bool ushape = USESHAPE;
static char txtdpy[256] = "";
static char txtdev[256] = DEFAULTDEVICE;
static char ledcol[256] = LEDCOLOR;
static char bckcol[256] = BACKCOLOR;
static float ampfact = 1;

//for sound input
static bool sound_on=false; 
static bool use_stdin=false; 
static int audio_fd;

//atoms for deleting window
static Atom _XA_GNUSTEP_WM_FUNC;
static Atom WM_DELETE_WINDOW;

Display *dpy;
Window Win[2];
Window Root;
XWMHints *hints;
GC WinGC, mGC;
int activeWin;

// Standard dock-app stuff
void initXWin(int argc, char *argv[]);
void freeXWin();
void createWin(Window *win);
unsigned long getColor(char *colorName, float dim);

void scanArgs(int argc, char *argv[]);
void checkStatus(bool forced);
void pressEvent(XButtonEvent *xev);
void repaint();
void sinus_update();
void  sound_update();

void createPixmap(char *data[], char *buf, Pixmap *image, Pixmap *mask, int *width, int *height);


static int sine[256];

int main(int argc, char *argv[])
{
   scanArgs(argc, argv);
   initXWin(argc, argv);
   
   for(int i = 0;i<256;i++) 
    sine[i] = (int)(sin(5.*2.*M_PI*i/256.)*10.0) ;

   createPixmap(tile_xpm, NULL, &tile, NULL, NULL, NULL);
   createPixmap(cover_xpm, NULL, &cover, &dmsk, NULL, NULL);
   disp = XCreatePixmap(dpy, Root, 64, 64, DefaultDepth(dpy,DefaultScreen(dpy)));

   XGCValues gcv;
   unsigned long gcm;
   gcm = GCForeground|GCBackground|GCGraphicsExposures;
   gcv.graphics_exposures = False;
   WinGC = XCreateGC(dpy, Root, gcm, &gcv);
   mGC = XCreateGC(dpy, dmsk, gcm, &gcv);
   
   if(!(wmaker || ushape)){
      XCopyArea(dpy, tile, disp, WinGC, 0, 0, 64, 64, 0, 0);
      XSetClipMask(dpy, WinGC, dmsk);
   }
   XCopyArea(dpy, cover, disp, WinGC, 5, 5, 54, 54, 5, 5);
   XSetForeground(dpy, WinGC, getColor(ledcol,1.00));
   if(wmaker || ushape)
      XShapeCombineMask(dpy, Win[activeWin], ShapeBounding, 0, 0, dmsk, ShapeSet);
   XSetClipOrigin(dpy, WinGC, 0, 0);
   XSetClipMask(dpy, WinGC, None);


   sinus_update();
   XEvent event;
   XSelectInput(dpy, Win[activeWin], ButtonPress /*| ExposureMask*/);
   XMapWindow(dpy, Win[0]);


   bool finished=false;
   while(!finished){
      while(XPending(dpy)){
	 XNextEvent(dpy,&event);
	 switch(event.type){
		 case ButtonPress:
			 pressEvent(&event.xbutton);
			 break;
		 case ClientMessage:
			 if((Atom)event.xclient.data.l[0]==WM_DELETE_WINDOW)
			    finished=true;
			 break;
	 }
      }
      if(!sound_on) {
      sinus_update();
      XFlush(dpy);
      usleep(10);
      } else {
	 sound_update();
	 XFlush(dpy);

	 //usleep(10);
      }
   }
   XFreeGC(dpy, WinGC);
   XFreeGC(dpy, mGC);
   // Free pixmaps not in Artwork
   XFreePixmap(dpy, tile);
   // Free runtime pixmaps
   XFreePixmap(dpy, disp);
   XFreePixmap(dpy, dmsk);
   // Finish with X stuff
   freeXWin();
   // Free Artwork data
   return 0;
}

void initXWin(int argc, char *argv[]){
   if((dpy=XOpenDisplay(txtdpy))==NULL){
      fprintf(stderr,"cannot open display!\n");
      exit(1);
   }
   _XA_GNUSTEP_WM_FUNC = XInternAtom(dpy, "_GNUSTEP_WM_FUNCTION", False);
   WM_DELETE_WINDOW = XInternAtom(dpy, "WM_DELETE_WINDOW", False);
   Root=DefaultRootWindow(dpy);
   createWin(&Win[0]);
   createWin(&Win[1]);
   XWMHints hints;
   XSizeHints shints;
   hints.window_group = Win[0];
   shints.min_width=64;
   shints.min_height=64;
   shints.max_width=64;
   shints.max_height=64;
   shints.x=0;
   shints.y=0;
   if(wmaker){
      hints.initial_state = WithdrawnState;
      hints.icon_window = Win[1];
      hints.flags = WindowGroupHint | StateHint | IconWindowHint;
      shints.flags = PMinSize | PMaxSize | PPosition;
      activeWin=1;
   }
   else{
      hints.initial_state = NormalState;
      hints.flags = WindowGroupHint | StateHint;
      shints.flags = PMinSize | PMaxSize;
      activeWin=0;
   }
   XSetWMHints(dpy, Win[0], &hints);
   XSetWMNormalHints(dpy, Win[0], &shints);
   XSetCommand(dpy, Win[0], argv, argc);
   XStoreName(dpy, Win[0], NAME);
   XSetIconName(dpy, Win[0], NAME);
   XSetWMProtocols(dpy, Win[activeWin], &WM_DELETE_WINDOW, 1);
}

void freeXWin(){
   XDestroyWindow(dpy, Win[0]);
   XDestroyWindow(dpy, Win[1]);
   XCloseDisplay(dpy);
}

void createWin(Window *win){
   XClassHint classHint;
   *win = XCreateSimpleWindow(dpy, Root, 10, 10, 64, 64,0,0,0);
   classHint.res_name = NAME;
   classHint.res_class = CLASS;
   XSetClassHint(dpy, *win, &classHint);
}

unsigned long getColor(char *colorName, float dim)
{
   XColor Color;
   XWindowAttributes Attributes;

   XGetWindowAttributes(dpy, Root, &Attributes);
   Color.pixel = 0;

   XParseColor (dpy, Attributes.colormap, colorName, &Color);
   Color.red=(unsigned short)(Color.red/dim);
   Color.blue=(unsigned short)(Color.blue/dim);
   Color.green=(unsigned short)(Color.green/dim);
   Color.flags=DoRed | DoGreen | DoBlue;
   XAllocColor (dpy, Attributes.colormap, &Color);

   return Color.pixel;
}

void scanArgs(int argc, char *argv[]){
	for(int i=1;i<argc;i++){
		if(strcmp(argv[i],"-h")==0 || strcmp(argv[i],"-help")==0 || strcmp(argv[i],"--help")==0){
			fprintf(stderr,"wmscope (C) 1999 John Meacham (john@foo.net).\n\n");
			fprintf(stderr,"usage:\n\n   %s [options]\n\noptions:\n\n",argv[0]);
			fprintf(stderr,"   -h | -help | --help    display this help screen\n");
			fprintf(stderr,"   -w                     use WithdrawnState    (for WindowMaker)\n");
			fprintf(stderr,"   -s                     shaped window\n");
			fprintf(stderr,"   -l led_color           use the specified color for led displays\n");
			fprintf(stderr,"   -b back_color          use the specified color for backgrounds\n");
			fprintf(stderr,"   -a amp_factor          signal amplification factor (2 = 2x)\n");
			fprintf(stderr,"   -d dsp_dev             use specified device  (rather than /dev/dsp)\n");
			fprintf(stderr,"   -c                     read sound data from stdin.(raw 8bit unsigned)\n");
			fprintf(stderr,"   -display display       select target display (see X manual pages)\n\n");
			exit(0);
		}
		if(strcmp(argv[i],"-w")==0)
			wmaker=true;
		if(strcmp(argv[i],"-s")==0)
			ushape=true;
		if(strcmp(argv[i],"-d")==0){
			if(i<argc-1){
				i++;
				sprintf(txtdev,"%s",argv[i]);
			}
			continue;
		}
		if(strcmp(argv[i],"-a")==0){
			if(i<argc-1){
				i++;
				ampfact = (float)atof(argv[i]);
			}
			continue;
		}
		if(strcmp(argv[i],"-l")==0){
			if(i<argc-1){
				i++;
				sprintf(ledcol,"%s",argv[i]);
			}
			continue;
		}
		if(strcmp(argv[i],"-c")==0){
			use_stdin = true;
			audio_fd = STDIN_FILENO;
			continue;
		}
		if(strcmp(argv[i],"-b")==0){
			if(i<argc-1){
				i++;
				sprintf(bckcol,"%s",argv[i]);
			}
			continue;
		}
		if(strcmp(argv[i],"-display")==0){
			if(i<argc-1){
				i++;
				sprintf(txtdpy,"%s",argv[i]);
			}
			continue;
		}
	}
}

void pressEvent(XButtonEvent *xev){
	//int x=xev->x;
	//int y=xev->y;
	sound_on = !sound_on;
	if(use_stdin)
		return;
	if(!sound_on ) {
		close(audio_fd);
		return;	  
	}
	audio_fd = open(txtdev,O_RDONLY);
	if(audio_fd==-1) {
		perror(txtdev);
		sound_on = false;
		return;
	}
	int arg = 0x00020008;
	if (ioctl(audio_fd, SNDCTL_DSP_SETFRAGMENT, &arg)) {
		perror(txtdev);
		sound_on = false;
		return;
	}
	int speed = SAMPLING_SPEED;
	ioctl(audio_fd, SNDCTL_DSP_SPEED, &speed);
	cerr << "Sampling Rate: " << speed << endl;
	int format = AFMT_U8;  
	if (ioctl(audio_fd, SNDCTL_DSP_SETFMT, &format)==-1)  
	{ /* Fatal error */  
		perror("SNDCTL_DSP_SETFMT");  
		sound_on = false;
		return;
	}  
	if(format !=AFMT_U8) {
		cerr << "Could not set " << txtdev << " to unsigned 8 bit mode\n";
		cerr << "results are probably incorrect.\n";
	} else
		cerr << "Mode: 8 bit unsigned.\n";
}

void sinus_update(){
	static int loc=0;
	static int loc1=0;
	XPoint pts[52];
	XCopyArea(dpy, cover, disp, WinGC, 5, 5, 54, 54, 5, 5);
	for(int i = 0;i<52;i++)  {
		int y = sine[((loc+i))&0xFF];
		y += sine[((y+i))&0xFF];
		y += sine[((loc1+i))&0xFF];
		loc1++;
		y+=26;
		//XDrawPoint(dpy, disp,WinGC,i+6,y+6);
		pts[i].x =i+6;
		pts[i].y =y+6;
	}
	XDrawLines(dpy,disp,WinGC,pts,52,CoordModeOrigin);
	loc++;
	XCopyArea(dpy,disp,Win[activeWin],WinGC,0,0,64,64,0,0);
}

void sound_update(){
	XCopyArea(dpy, cover, disp, WinGC, 5, 5, 54, 54, 5, 5);
	unsigned char buf[256];
	read(audio_fd,buf,52);
	XPoint pts[52];
	for(int i = 0;i<52;i++)  {
		int y = ((int)(buf[i]-128)*((int)(26*ampfact))/128)+26;
		//XDrawPoint(dpy, disp,WinGC,i+6,y+6);
		pts[i].x =i+6;
		pts[i].y =y+6;
	}
	XDrawLines(dpy,disp,WinGC,pts,52,CoordModeOrigin);
	XCopyArea(dpy,disp,Win[activeWin],WinGC,0,0,64,64,0,0);
}

void createPixmap(char *data[], char *buf, Pixmap *image, Pixmap *mask, int *width, int *height){
	XpmAttributes pixatt;
	XpmColorSymbol ledcols[4]={{"led_color_high", NULL, 0},
		{"led_color_med",  NULL, 0},
		{"led_color_low",  NULL, 0},
		{"color_back",     NULL, 0}};
		ledcols[0].pixel=getColor(ledcol,1.00);
		ledcols[1].pixel=getColor(ledcol,1.65);
		ledcols[2].pixel=getColor(ledcol,2.60);
		ledcols[3].pixel=getColor(bckcol,1.00);
		pixatt.numsymbols=4;
		pixatt.colorsymbols=ledcols;
		pixatt.exactColors=false;
		pixatt.closeness=40000;
		pixatt.valuemask=XpmColorSymbols | XpmExactColors | XpmCloseness | XpmSize;
		if(data!=NULL)
			XpmCreatePixmapFromData(dpy, Root, data, image, mask, &pixatt);
		else
			XpmCreatePixmapFromBuffer(dpy, Root, buf, image, mask, &pixatt);
		if(width!=NULL)
			*width=pixatt.width;
		if(height!=NULL)
			*height=pixatt.height;
}

