/*
 * Code based on some of the Window maker programs found on the internet
 *
 * Author: Dag Wieers <dag@digibel.be>
 *
 * This program is distributed under the GPL license. 
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <time.h>

#include <X11/xpm.h>

#include "../wmgeneral/wmgeneral.h"
#include "wmpong.h"
#include "wmpong-master.xpm"

#define USLEEP 20000
#define MAX_COLORS 10		/* don't change these */
#define X_MIN 5	
#define X_MAX 55.0
#define Y_MIN 5
#define Y_MAX 44.0

struct xpm_position {
 int x, y;
};
struct xpm_surface {
 int x, y, w, h;
};
struct ball {
 int x, y, xd, yd, col, thickness;
};

void init_ball(struct ball *);
void move_ball(struct ball *);
void collision_balls(struct ball *, struct ball *);
void bounce_ball(struct ball *);
void draw_ball(struct ball *);
void erase_ball(struct ball *);

struct xpm_position pos[]={
 {5,50},{16,50},{27,50},{38,50},{49,50}
};
struct xpm_surface rel[]={
 {1,70,11,9},{12,70,11,9},{23,70,11,9},{34,70,11,9},{45,70,11,9}
};
struct xpm_surface prs[]={
 {1,79,11,9},{12,79,11,9},{23,79,11,9},{34,79,11,9},{45,79,11,9}
};
struct xpm_surface oball={4,66,MAX_THICKNESS,MAX_THICKNESS}; 
struct xpm_surface bball={1,66,MAX_THICKNESS,MAX_THICKNESS}; 

void main(int argc,char *argv[]) {
 XEvent Event;

 char wmpong_mask_bits[64*64];
 int wmpong_mask_width = 64;
 int wmpong_mask_height = 64;
 int i,j,bnr=NR_BALLS;
 struct ball b[MAX_BALLS];

 srand(time(NULL));

 createXBMfromXPM(wmpong_mask_bits, wmpong_master_xpm, wmpong_mask_width, wmpong_mask_height);
 openXwindow(argc,argv,wmpong_master_xpm,wmpong_mask_bits,wmpong_mask_width,wmpong_mask_height);

 for(i=0;i<5;i++)
  AddMouseRegion(i,pos[i].x,pos[i].y,pos[i].x+prs[i].w,pos[i].y+prs[i].h);
 
 for(i=0;i<bnr;i++) {
  init_ball(&b[i]);
 }

 while (1) {
  for(i=0;i<bnr;i++){
   move_ball(&b[i]);
   for (j=0;j<i;j++)
    collision_balls(&b[i],&b[j]);
   bounce_ball(&b[i]);
   draw_ball(&b[i]);
  }

  RedrawWindow();

  for(i=0;i<bnr;i++)
   erase_ball(&b[i]);

  while (XPending(display)) {
   XNextEvent(display, &Event);
   switch (Event.type) {
    case Expose:
     RedrawWindow();
     break;
    case DestroyNotify:
     XCloseDisplay(display);
     exit(0);
     break;
    case ButtonPress:
     i = CheckMouseRegion(Event.xbutton.x, Event.xbutton.y);
     copyXPMArea(prs[i].x,prs[i].y,prs[i].w,prs[i].h,pos[i].x,pos[i].y);
     switch(i) {
      case 0:
       init_ball(&b[bnr]);
       if (bnr<MAX_BALLS) bnr++;
       break;
      case 1:
       if (bnr>0) bnr--;
       break;
      case 2:
       printf("Button has no function yet !\n"); 
       break;
      case 3:
       printf("Button has no function yet !\n"); 
       break;
      case 4:
       for(i=0;i<bnr;i++)
        init_ball(&b[i]);
       break;
     }
     break;
    case ButtonRelease:
     i = CheckMouseRegion(Event.xbutton.x, Event.xbutton.y);
     copyXPMArea(rel[i].x,rel[i].y,rel[i].w,rel[i].h,pos[i].x,pos[i].y);
     break;
   }		
  } 
  usleep(USLEEP);
 }
}

void init_ball(struct ball *b) {
 int i=0;
 b->thickness=MIN_THICKNESS+(int)((MAX_THICKNESS-1)*1.0*rand()/(RAND_MAX+1.0));
 b->x=1+X_MIN+(int)((X_MAX-b->thickness-X_MIN)*rand()/(RAND_MAX+1.0));
 b->y=1+Y_MIN+(int)((Y_MAX-b->thickness-Y_MIN)*rand()/(RAND_MAX+1.0));
 i=(1.0*rand()/(RAND_MAX+1.0)<.5?-1:1);
 b->xd=i*(MIN_SPEED+(int)((MAX_SPEED+1.0)*rand()/(RAND_MAX+1.0)));
 i=(1.0*rand()/(RAND_MAX+1.0)<.5?-1:1);
 b->yd=i*(MIN_SPEED+(int)((MAX_SPEED+1.0)*rand()/(RAND_MAX+1.0)));
 b->col=(int)(MAX_COLORS*1.0*rand()/(RAND_MAX+1.0));
}

void move_ball(struct ball *b) {
 /* MOTION OF A BALL */
 b->x+=b->xd;
 b->y+=b->yd;
}

void collision_balls(struct ball *a, struct ball *b) {
 /* COLLISION OF A BALL */
 if((a->x>=b->x-1 && a->x<=b->x+1)&&
    (a->y>=b->y-1 && a->y<=b->y+1)) {
  if(a->xd*b->xd<1) {
   a->xd=-a->xd;
   b->xd=-b->xd;
  }
  if(a->yd*b->yd<1) {
   a->yd=-a->yd;
   b->yd=-b->yd;
  }
 }
}

void bounce_ball(struct ball *b) {
 /* OUTBREAK OF A BALL */
 if (b->x+b->xd<X_MIN || b->x+b->xd>X_MAX-b->thickness+4) {
  b->xd=-b->xd;
  b->x+=b->xd;
 } 
 if (b->y+b->yd<Y_MIN || b->y+b->yd>Y_MAX-b->thickness+4) {
  b->yd=-b->yd;
  b->y+=b->yd;
 }
}

void draw_ball(struct ball *b) {
 copyXPMArea(oball.x+(4*b->col),oball.y,b->thickness,b->thickness,b->x,b->y);
}

void erase_ball(struct ball *b) {
 copyXPMArea(bball.x,bball.y,b->thickness,b->thickness,b->x,b->y);
}
