#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/types.h>
#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>
#include "../wmgeneral/wmgeneral.h"
#include "../wmgeneral/misc.h"
#include "master.xpm"

#define WMLMON_VERSION "2.0"

int fahr=0;
char wmlmon_mask_bits[64*64];
int wmlmon_mask_width = 64;
int wmlmon_mask_height = 64;
int scrdelay=10;

// proc dirs for lm75 & 78 reading
char lm75[256];
char lm78[256];

float core1,core2;
float cputemp, mbtemp, fan1, fan2, fan3, act;
float ioV,ioVmax,ioVmin;
float coreV,coreVmax,coreVmin;
float v5p,v5pmax,v5pmin;
float v5n,v5nmax,v5nmin;
float v12p,v12pmax,v12pmin;
float v12n,v12nmax,v12nmin;
float v33p,v33pmax,v33pmin;

void initsens(void);
void getlm(void);
void usage(void);
void printversion(void);
void wmlmon_routine(int, char **);

int main(int argc, char *argv[]) {
 int i;
 for (i=1; i<argc; i++) {
  char *arg = argv[i];
  if (*arg=='-') {
   switch (arg[1]) {
    case 'd':
     if (strcmp(arg+1, "display")) {
      usage();
      exit(1);
     }
    break;
    case 'f':
     fprintf(stderr,"Using Fahrenheit temperatures\n");
     fahr=1;
     break;
    case 'v':
     printversion();
     exit(0);
     break;
    case 'w':
     scrdelay=atoi(arg+3);
    break;
    default:
     usage();
     exit(0);
    break;
   }
  }
 }
 initsens();
 wmlmon_routine(argc, argv);
}

void initsens(void)
{
 FILE *fe;
 char *buf;
 char *chip;
 char *temp;

 buf=malloc(sizeof(char)*256);
 chip=malloc(sizeof(char)*256);

 fe=fopen("/proc/sys/dev/sensors/chips","r");
 if (!fe) { fprintf(stderr,"Unable to access lm_sensors proc data\nMaybe you forgot to insmod lm_sensors?\n");
 	exit(1);
 }

 while(fgets(buf,64,fe)!=NULL) {
  temp=strstr(buf,"lm");
  strcpy(chip,"/proc/sys/dev/sensors/");
  strncat(chip,temp,strlen(temp)-1);

  if(strstr(chip,"lm75")) {
   strcpy(lm75,chip);
   printf("LM75 Sensor @ %s\n",lm75);
  }
  if(strstr(chip,"lm78")) {
   strcpy(lm78,chip);
   printf("LM78 Sensor @ %s\n",lm78);
  }
 }

 if (lm75[0]==0 && lm78[0]==0) { fprintf(stderr,"No sensors found, exiting...\n"); exit(1); }

 fclose(fe); 
 free(buf);
 free(chip);
}

void getlm(void)
{
 FILE *fe;
 char *buf;
 char *tempstr;
 float temp;

 buf=malloc(sizeof(char)*256);
 tempstr=malloc(sizeof(char)*256); 

 if (lm75[0]=='/') {
   strcpy(tempstr,lm75);
   strcat(tempstr,"/temp");
   fe=fopen(tempstr,"r");
   fgets(buf,127,fe);
   sscanf(buf,"%f %f %f",&temp,&temp,&cputemp);
   fclose(fe);
 }
 else 
   cputemp=0;

 if (lm78[0]=='/') {
   strcpy(tempstr,lm78);
   strcat(tempstr,"/temp");
   fe=fopen(tempstr,"r"); 
   fgets(buf,127,fe);
   sscanf(buf,"%f %f %f",&temp,&temp,&mbtemp);
   fclose(fe);
 }
 else
   mbtemp=0;

 if (lm78[0]=='/') {
  strcpy(tempstr,lm78);
  strcat(tempstr,"/in0");
  fe = fopen(tempstr, "r");
  fgets(buf,127,fe);
  sscanf(buf,"%f\t%f\t%f",&coreVmin,&coreVmax,&coreV);
  fclose(fe);
 }
  else coreVmin=coreVmax=coreV=0;

 if (lm78[0]=='/') {
  strcpy(tempstr,lm78);
  strcat(tempstr,"/in1");
  fe = fopen(tempstr, "r");
  fgets(buf,127,fe);
  sscanf(buf,"%f\t%f\t%f",&ioVmin,&ioVmax,&ioV);
  fclose(fe);
 }
  else ioVmin=ioVmax=ioV=0;
 
 if (lm78[0]=='/') {
  strcpy(tempstr,lm78);  
  strcat(tempstr,"/in2");  
  fe = fopen(tempstr, "r");
  fgets(buf,127,fe);
  sscanf(buf,"%f\t%f\t%f",&v33pmin,&v33pmax,&v33p);
  fclose(fe);
 }
  else v33pmin=v33pmax=v33p=0;

 if (lm78[0]=='/') {
  strcpy(tempstr,lm78);  
  strcat(tempstr,"/in3");  
  fe = fopen(tempstr, "r");
  fgets(buf,127,fe);
  sscanf(buf,"%f\t%f\t%f",&v5pmin,&v5pmax,&v5p);
  v5p=v5p*1.68;
  v5pmin=v5pmin*1.68;  
  v5pmax=v5pmax*1.68;
  fclose(fe);
 }
  else v5pmin=v5pmax=v5p=0;

 if (lm78[0]=='/') {
  strcpy(tempstr,lm78);  
  strcat(tempstr,"/in4");  
  fe = fopen(tempstr, "r");
  fgets(buf,127,fe);
  sscanf(buf,"%f\t%f\t%f",&v12pmin,&v12pmax,&v12p);
  v12p=v12p*3.8;
  v12pmin=v12pmin*3.8;
  v12pmax=v12pmax*3.8;
  fclose(fe);
 }
  else v12pmin=v12pmax=v12p=0;
 
 if (lm78[0]=='/') {
  strcpy(tempstr,lm78);  
  strcat(tempstr,"/in5");  
  fe = fopen(tempstr, "r");
  fgets(buf,127,fe);
  sscanf(buf,"%f\t%f\t%f",&v12nmin,&v12nmax,&v12n);
  v12n=v12n*3.477;
  v12nmin=v12nmin*3.477;
  v12nmax=v12nmax*3.477;
  fclose(fe);
 }
  else v12nmin=v12nmax=v12n=0;
 
 if (lm78[0]=='/') {
  strcpy(tempstr,lm78);  
  strcat(tempstr,"/in6");  
  fe = fopen(tempstr, "r");
  fgets(buf,127,fe);
  sscanf(buf,"%f\t%f\t%f",&v5nmin,&v5nmax,&v5n);
  v5n=v5n*1.51;
  v5nmin=v5nmin*1.51;
  v5nmax=v5nmax*1.51;
  fclose(fe);     
 }
  else v5nmin=v5nmax=v5n=0;
 
 free(buf);
 free(tempstr);

 if (fahr) {
   if (cputemp!=0)
     cputemp=((9.0/5.0)*cputemp)+32;
   if (mbtemp!=0)
     mbtemp=((9.0/5.0)*mbtemp)+32;
 }
}

void wmlmon_routine(int argc, char **argv) {
 double temp;
 XEvent	Event;
 int tempint,i,scroll;

 createXBMfromXPM(wmlmon_mask_bits, master_xpm, wmlmon_mask_width, wmlmon_mask_height);
 openXwindow(argc, argv, master_xpm, wmlmon_mask_bits, wmlmon_mask_width, wmlmon_mask_height);

 AddMouseRegion(0,5,5,59,15);
 AddMouseRegion(1,5,19,59,29);

 if (fahr) {
  copyXPMArea(14,75,5,9,52,5);
  copyXPMArea(14,75,5,9,52,19);
 }

 while (1) {
  getlm();
  tempint=cputemp;
  if (tempint>=100) {
   tempint=tempint-100;
   copyXPMArea(9, 65, 6, 9, 31, 5);
  } else {
   copyXPMArea(3, 65, 6, 9, 31, 5);
  }
  copyXPMArea(3 + (tempint % 10)*6, 65, 6, 9, 43, 5);
  copyXPMArea(3 + (tempint / 10)*6, 65, 6, 9, 37, 5);
		
  tempint=mbtemp;
  if (tempint>=100) {
   tempint=tempint-100;
   copyXPMArea(9, 65, 6, 9, 31, 19);
  } else {
   copyXPMArea(3, 65, 6, 9, 31, 19);
  }
  copyXPMArea(3 + (tempint % 10)*6, 65, 6, 9, 43, 19);
  copyXPMArea(3 + (tempint / 10)*6, 65, 6, 9, 37, 19);

  
  // This is beyond lame.  I REALLY need to learn C properly.
  temp=(coreVmax-coreVmin)/4.0; 
  if ((coreV<(coreVmax-temp))&&(coreV>(coreVmin+temp)))
    copyXPMArea(25,82,4,4,46,34); //Row 1 Column 1
  else
    copyXPMArea(31,77,4,4,46,34);
  
  temp=(ioVmax-ioVmin)/4.0; 
  if ((ioV<(ioVmax-temp))&&(ioV>(ioVmin+temp)))
    copyXPMArea(25,82,4,4,53,34); //Row 1 Column 2
  else
    copyXPMArea(31,77,4,4,53,34);

  temp=(v33pmax-v33pmin)/4.0;
  if ((ioV<(v33pmax-temp))&&(v33p>(v33pmin+temp)))
    copyXPMArea(25,82,4,4,46,40); //Row 2 Column 1
  else
    copyXPMArea(31,77,4,4,46,40);

  temp=(v5pmax-v5pmin)/4.0;
  if ((v5p<(v5pmax-temp))&&(v5p>(v5pmin+temp)))
    copyXPMArea(25,82,4,4,46,46); //Row 3 Column 1
  else
    copyXPMArea(31,77,4,4,46,46);

  temp=(v5nmax-v5nmin)/4.0;
  if ((v5n<(v5nmax-temp))&&(v5n>(v5nmin+temp)))
    copyXPMArea(25,82,4,4,53,46); //Row 3 Column 2
  else
    copyXPMArea(31,77,4,4,53,46);

  temp=(v12pmax-v12pmin)/4.0;
  if ((v12p<(v12pmax-temp))&&(v12p>(v12pmin+temp)))
    copyXPMArea(25,82,4,4,46,52); //Row 4 Column 1
  else
    copyXPMArea(31,77,4,4,46,52);
  temp=(v12nmax-v12nmin)/4.0;
  if ((v12n<(v12nmax-temp))&&(v12n>(v12nmin+temp)))
    copyXPMArea(25,82,4,4,53,52); //Row 4 Column 2
  else
    copyXPMArea(31,77,4,4,53,52);

  // scroll and update bar graphs - at least now they actually SCROLL right :)
  // now they also scroll slower - requested by many people.

  scroll++;  
  if(scroll>scrdelay) {
   copyXPMArea(6,33,34,26,5,33);
   copyXPMArea(68,33,1,26,39,33);
   tempint=(fahr?( (cputemp-32)*5/9 ):cputemp);
   copyXPMArea(26,88,1,1,39,80-(tempint));
   tempint=(fahr?( (mbtemp-32)*5/9 ):mbtemp);
   copyXPMArea(27,88,1,1,39,80-(tempint));
   scroll=0;
  }
  
  RedrawWindow();
	
  while (XPending(display)) {
   XNextEvent(display, &Event);
   switch (Event.type) {
    case Expose:
     RedrawWindow();
    break;
    case ButtonRelease:
     i = CheckMouseRegion(Event.xbutton.x, Event.xbutton.y);
     switch (i) {
      case 0:
       fahr=1;
       copyXPMArea(14,75,5,9,52,5);
       copyXPMArea(14,75,5,9,52,19);
      break;
      case 1:
       fahr=0;
       copyXPMArea(19,75,5,9,52,5);
       copyXPMArea(19,75,5,9,52,19);
      break;
     }
    break;
    case DestroyNotify:
     XCloseDisplay(display);
     exit(0);
    break;
   }
  }
  usleep(1000000L);
 }
}

void usage(void) {
 fprintf(stderr, "\nwmlmon - version %s, by timecop@linuxwarez.com\n\n",WMLMON_VERSION);
 fprintf(stderr, "usage:\n");
 fprintf(stderr, "\t-display <display name>\n");
 fprintf(stderr, "\t-f\tuse Fahrenheit temperatures instead of Celsius\n");
 fprintf(stderr, "\t-h\tthis screen\n");
 fprintf(stderr, "\t-v\tprint the version number\n");
 fprintf(stderr, "\t-w num\tnumber of seconds to wait before scrolling graphs [10]\n");
 fprintf(stderr, "\n");
}

void printversion(void) {
 fprintf(stderr, "wmlmon %s\n", WMLMON_VERSION);
}
