/*
 * This module is basically a hack of alot of other
 * WM apps, cuz I probably stole code from just about
 * everyone ;)
 * 
 * This should work as long as you have the lm78 kernel
 * module I have supplied with this code, installed and
 * running on your system
 */

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>

#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/ioctl.h>

#include "wmlm78-mask.xbm"
#include "wmlm78-master.xpm"

#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#define VERSION "DR1"

char *ProgName;
int pixels_per_byte;

/*
 * Let's define some X11 stuff here.
 */
Display         *display;
Window          Root;
int			screen;
int			x_fd;
int			d_depth;
XSizeHints	mysizehints;
XWMHints	mywmhints;
Pixel		back_pix, fore_pix;
char		*Geometry = "";
Window		iconwin, win;
GC			NormalGC;

/*
 * Define some pixmap stuff
 */
typedef struct _XpmIcon {
	Pixmap			pixmap;
	Pixmap			mask;
	XpmAttributes	attributes;
} XpmIcon;

XpmIcon wmlm78_pixmap;

/*
 * Define the functions here
 */
void usage(void);
void printversion(void);
void GetXPM(void);
Pixel GetColor(char *);
void RedrawWindow(XpmIcon *);
void openXwindow(int, char **);
/* Called from lm78lib */
int do_mbtemp(int, char **);
int do_cputemp(int, char **);

/* These are our main functions..does what needs done */
void lm78_routine(int, char**);
void DrawMB(int);
void DrawCPU(int);

/*
 * End of function definitions
 */

void main(int argc, char *argv[]) {

    int		i;
    /* Parse Command Line */
    ProgName = argv[0];
    if (strlen(ProgName) >= 5)
	    ProgName += (strlen(ProgName) - 5);
    for (i=1; i<argc; i++) {
	    char *arg = argv[i];
	    if (*arg=='-') {
		    switch (arg[1]) {
		    case 'v' :
		    	printversion();
		    	exit(0);
		    	break;
		    default:
		    	usage();
		    	exit(0);
		    	break;
		    }
	    }
    }
    lm78_routine(argc, argv);
}

void lm78_routine(int argc, char **argv) {
    
    XEvent      Event;
    int mb;
    int cpu; 
    openXwindow(argc, argv); 
    while (1) {
   
        while (XPending(display)) {
			XNextEvent(display, &Event);
			switch (Event.type) {
			case Expose:
    			RedrawWindow(&wmlm78_pixmap);
				break;
			case DestroyNotify:
				XCloseDisplay(display);
				exit(0);
				break;
                        }
        }
    mb = do_mbtemp(argc, argv);
    cpu = do_cputemp(argc, argv);
    DrawMB(mb);
    DrawCPU(cpu);
    RedrawWindow(&wmlm78_pixmap);
    usleep(5000000L);
    
    }
}

void DrawMB(int temp) {
  int i = temp;
  int k = 18;
  int l,srcx, destx;

  while (i) {
      l = i % 10;
      srcx = l * 6;
      destx = (k-=6); 
      XCopyArea(display, wmlm78_pixmap.pixmap, wmlm78_pixmap.pixmap, NormalGC, srcx, 64, 6, 9, destx, 17);
      i /= 10;
   }
}

void DrawCPU(int temp) {
  int i = temp;
  int k = 18;
  int l,srcx, destx;

  while (i) {
      l = i % 10;
      srcx = l * 6;
      destx = (k-=6); 
      XCopyArea(display, wmlm78_pixmap.pixmap, wmlm78_pixmap.pixmap, NormalGC, srcx, 64, 6, 9, destx, 48);
      i /= 10; 
  } 
}

void usage(void) {
    fprintf(stderr, "\nwmlm78: coded and hacked by DaJoker\n\n");
    fprintf(stderr, "usage:\n");
    fprintf(stderr, "\t-h\tDisplay this help\n");
    fprintf(stderr, "\t-v\tDisplay the version number\n");
    fprintf(stderr, "\n");
}
void printversion(void) {
    fprintf(stderr, "wmlm78 %s\n", VERSION);
} 


/*******************************************************************************\
|* flush_expose																   *|
\*******************************************************************************/

int flush_expose(Window w) {

	XEvent 		dummy;
	int			i=0;

	while (XCheckTypedWindowEvent(display, w, Expose, &dummy))
		i++;

	return i;
}

/*******************************************************************************\
|* RedrawWindow																   *|
\*******************************************************************************/

void RedrawWindow(XpmIcon *v) {
	
	flush_expose(iconwin);
	XCopyArea(display, v->pixmap, iconwin, NormalGC, 
				0,0, v->attributes.width, v->attributes.height, 0,0);
	flush_expose(win);
	XCopyArea(display, v->pixmap, win, NormalGC,
				0,0, v->attributes.width, v->attributes.height, 0,0);
}

/*******************************************************************************\
|* GetXPM																	   *|
\*******************************************************************************/

void GetXPM(void) {

	XWindowAttributes	attributes;
	int					err;

	/* For the colormap */
	XGetWindowAttributes(display, Root, &attributes);

		wmlm78_pixmap.attributes.valuemask |= (XpmReturnPixels | XpmReturnExtensions);
		err = XpmCreatePixmapFromData(display, Root, wmlm78_master_xpm, &wmlm78_pixmap.pixmap,
						&wmlm78_pixmap.mask, &wmlm78_pixmap.attributes);
	
	if (err != XpmSuccess) {
		fprintf(stderr, "Not enough free colorcells.\n");
		exit(1);
	}
}

/*******************************************************************************\
|* GetColor																	   *|
\*******************************************************************************/

Pixel GetColor(char *name) {

	XColor				color;
	XWindowAttributes	attributes;

	XGetWindowAttributes(display, Root, &attributes);

	color.pixel = 0;
	if (!XParseColor(display, attributes.colormap, name, &color)) {
		fprintf(stderr, "wmlm78: can't parse %s.\n", name);
	} else if (!XAllocColor(display, attributes.colormap, &color)) {
		fprintf(stderr, "wmlm78: can't allocate %s.\n", name);
	}
	return color.pixel;
}

/*******************************************************************************\
|* openXwindow																   *|
\*******************************************************************************/
void openXwindow(int argc, char *argv[]) {

	unsigned int	borderwidth = 1;
	XClassHint		classHint;
	char			*display_name = NULL;
	char			*wname = ProgName;
	XTextProperty	name;

	XGCValues		gcv;
	unsigned long	gcm;

	Pixmap			pixmask;

	int				dummy=0;
	// int				i;

	if (!(display = XOpenDisplay(display_name))) {
		fprintf(stderr, "%s: can't open display %s\n", 
						ProgName, XDisplayName(display_name));
		exit(1);
	}
	screen  = DefaultScreen(display);
	Root    = RootWindow(display, screen);
	d_depth = DefaultDepth(display, screen);
	x_fd    = XConnectionNumber(display);

	/* Convert XPM to XImage */
	GetXPM();

	/* Create a window to hold the stuff */
	mysizehints.flags = USSize | USPosition;
	mysizehints.x = 0;
	mysizehints.y = 0;

	back_pix = GetColor("white");
	fore_pix = GetColor("black");

	XWMGeometry(display, screen, Geometry, NULL, borderwidth, &mysizehints,
				&mysizehints.x, &mysizehints.y,&mysizehints.width,&mysizehints.height, &dummy);

	mysizehints.width = 64;
	mysizehints.height = 64;
		
	win = XCreateSimpleWindow(display, Root, mysizehints.x, mysizehints.y,
				mysizehints.width, mysizehints.height, borderwidth, fore_pix, back_pix);
	
	iconwin = XCreateSimpleWindow(display, win, mysizehints.x, mysizehints.y,
				mysizehints.width, mysizehints.height, borderwidth, fore_pix, back_pix);

	/* Activate hints */
	XSetWMNormalHints(display, win, &mysizehints);
	classHint.res_name = ProgName;
	classHint.res_class = ProgName;
	XSetClassHint(display, win, &classHint);

	XSelectInput(display, win, ButtonPressMask | ExposureMask | ButtonReleaseMask | PointerMotionMask | StructureNotifyMask);
	XSelectInput(display, iconwin, ButtonPressMask | ExposureMask | ButtonReleaseMask | PointerMotionMask | StructureNotifyMask);

	if (XStringListToTextProperty(&wname, 1, &name) == 0) {
		fprintf(stderr, "%s: can't allocate window name\n", ProgName);
		exit(1);
	}

	XSetWMName(display, win, &name);

	/* Create GC for drawing */
	
	gcm = GCForeground | GCBackground | GCGraphicsExposures;
	gcv.foreground = fore_pix;
	gcv.background = back_pix;
	gcv.graphics_exposures = 0;
	NormalGC = XCreateGC(display, Root, gcm, &gcv);

	/* ONLYSHAPE ON */

	pixmask = XCreateBitmapFromData(display, win, wmlm78_mask_bits, wmlm78_mask_width, wmlm78_mask_height);

	XShapeCombineMask(display, win, ShapeBounding, 0, 0, pixmask, ShapeSet);
	XShapeCombineMask(display, iconwin, ShapeBounding, 0, 0, pixmask, ShapeSet);

	/* ONLYSHAPE OFF */

	mywmhints.initial_state = WithdrawnState;
	mywmhints.icon_window = iconwin;
	mywmhints.icon_x = mysizehints.x;
	mywmhints.icon_y = mysizehints.y;
	mywmhints.window_group = win;
	mywmhints.flags = StateHint | IconWindowHint | IconPositionHint | WindowGroupHint;

	XSetWMHints(display, win, &mywmhints);

	XSetCommand(display, win, argv, argc);
	XMapWindow(display, win);

}

