/**************************************************************************
 *  lm78 implementation for tx boards     v0.1
 * 
 *  (c) Ronald Schmidt 1997
 *
 *  tanx to Pedro Ortigao (Pedro.Ortigao@ip.pt) 
 *          who send me the specifikation  
 */

#include <linux/module.h>
#include <linux/version.h>
#include <linux/errno.h>
#include <linux/kernel.h>
#include <linux/major.h>
#include <linux/sched.h>
#include <linux/ioport.h>
#include <linux/fcntl.h>
#include <linux/delay.h>
#include <asm/io.h>
#include <linux/stat.h>
#include <linux/proc_fs.h>

#define MODULE_NAME "lm78"

#define AMD 8
#define CYRIX 15
#define INTEL 22

int CPUoffset = AMD;

char kernel_version[] = UTS_RELEASE;
unsigned long  m_SMBBA;                    //  SMBB addresse
unsigned short m_fan1div,m_fan2div;         


static int lm78_get_info(char *, char **, off_t, int, int);

static struct proc_dir_entry lm78_proc_entry = {
        0, 4, "lm78", 
        S_IFREG | S_IRUGO, 1, 0, 
        0, 0, 0, lm78_get_info
        };

int lm78_get_info(char *buf, char **start, off_t fpos, int length, int blablub)
{
        char *p;
        float dummy;
        int ch;
        unsigned char SMBHSTCNT,SMBHSTSTS;
        unsigned long maxtimeout=10000;
        unsigned long timeout ;
         
	p = buf;  

        outb(0x61, (unsigned short) 0x295);

        // get the core Voltage 
        dummy=((float) inb(0x296)) * 0.016f;
        p += sprintf(p,"coreV\t= %d.%d\n",
                        (unsigned short)dummy,
                        (unsigned short)(dummy*10-( (unsigned short)dummy *10) ));

        // get the IO Voltages (cpu)
        dummy=((float) inb(0x296)) * 0.016f;
        p += sprintf(p,"cpuioV\t= %d.%d\n",
                        (unsigned short)dummy,
                        (unsigned short)(dummy*10-( (unsigned short)dummy *10) ) );
								
	
        // get the 5 VOLT	
	dummy=((float) inb(0x296)) * 0.016f * 1.68f;
        p += sprintf(p,"+5VOLT\t= %d.%d\n",
                        (unsigned short)dummy,
                        (unsigned short)(dummy*10-( (unsigned short)dummy*10) ));
							
        // get the +12	Volt
	dummy=((float) inb(0x296)) * 0.016f * 3.8f;
        p += sprintf(p,"+12VOLT\t= %d.%d\n",
                        (unsigned short)dummy,
                        (unsigned short)(dummy*10-( (unsigned short)dummy *10) ));
							
	
        // get the -12 VOLT
	dummy=(((float) inb(0x296)) * -0.016f * 3.47f)*(-1);
        p += sprintf(p,"-12VOLT\t= -%d.%d\n",
                        (unsigned short)dummy,
                        (unsigned short)(dummy*10-( (unsigned short)dummy *10) ) );
								
	
        // get the -5 VOLT
	dummy=(((float) inb(0x296)) * -0.016f * 1.5f)*(-1);
        p += sprintf(p,"-5VOLT\t= -%d.%d\n",
                        (unsigned short)dummy,
                        (unsigned short)(dummy*10-( (unsigned short)dummy *10) ) );
								

	
        // get the mainboard temp
	dummy=inb(0x296);
        p += sprintf(p,"mb_temp\t= %d\n",(unsigned short)dummy);


        // get the fan1 speen
	if ((ch=inb(0x296))==0xFF) p +=sprintf(p,"fan1\t= not aviable\n");
                              else p +=sprintf(p,"fan1\t= %d\n",(unsigned int)(675000 / m_fan1div / ch ));
	
	// get the fan2 speed
        if ((ch=inb(0x296))==0xFF) p +=sprintf(p,"fan2\t= not aviable\n"); 
                              else p +=sprintf(p,"fan2\t= %d\n",(unsigned int)(675000 / m_fan2div / ch )); 
			   
	//get the fan3 speed
        if ((ch=inb(0x296))==0xFF) p +=sprintf(p,"fan3\t= not aviable\n");
                              else p +=sprintf(p,"fan3\t= %d\n",(unsigned int)(337500 / ch));


	
	SMBHSTSTS = inb(m_SMBBA);  timeout=0;
        while ( (SMBHSTSTS & 1) && (timeout<maxtimeout)) {
                SMBHSTSTS = inb(m_SMBBA);
                timeout++;  
        }
        if (timeout>=maxtimeout) printk("lm78: timeout\n");

        timeout=0;
        if ( ((SMBHSTSTS & 0x1E) != 0) && (timeout<maxtimeout)){
                outb(SMBHSTSTS, (unsigned short) m_SMBBA);
		timeout++;
        }
        if (timeout>=maxtimeout) printk("lm78: timeout\n");
        outb(0x00,(unsigned short) m_SMBBA+3);
        outb(0x93,(unsigned short) m_SMBBA+4);

        SMBHSTCNT = inb(m_SMBBA+2);
        SMBHSTCNT = ( SMBHSTCNT & 0xE0) | 0x0C;


        outb( SMBHSTCNT,(unsigned short) m_SMBBA+2);
        outb((SMBHSTCNT | 0x40),(unsigned short) m_SMBBA+2);

        timeout=0;
        while ( ( inb(m_SMBBA) & 0x1 ) && (timeout<maxtimeout)){ timeout++; }
        if (timeout>=maxtimeout) printk("lm78: timeout\n");

        
	// get the cpu temp
	dummy = inb(m_SMBBA+5) + ((inb(m_SMBBA+6)>>7) & 0x1) * 0.5f;
        dummy+=CPUoffset;
        p += sprintf(p,"cpu_tmp\t= %d\n",
                        (unsigned short)dummy);
        
        return p - buf;
}




/* INITMODULE -------------------------------------------------*/ 
int init_module(void)
{
    unsigned long pix; 
    unsigned char tmp;
    /* Is there a card in the system ? */
    printk("lm78: init (ronald.schmit@informatik.tu-chemnitz.de)\n");
    
    request_region(0x0cf8,10,"lm78");
	
    
    proc_register_dynamic(&proc_root, &lm78_proc_entry); 

   
    /* SMBBUS addr */
    pix = inl(0x0CF8);
    pix &= 0x7F000003;  
    pix |= 0x80000800;  
    pix |= (1<<11);     
    pix |= (3<<8);      
    pix |= (0x90);      
    outl(pix, (unsigned short) 0x0CF8);
    m_SMBBA = (unsigned short)inl(0x0CFC) - 1;

    /* FANDIVS */
    outb(0x47, (unsigned short) 0x295 );
    tmp = inb(0x296);
    m_fan1div = (tmp & 0x30) >> 4;
    m_fan2div = (tmp & 0xC0) >> 6;
    
    printk("lm78: SMBBA@%lx F1div=%d F2div=%d\n",m_SMBBA,m_fan1div,m_fan2div);

    request_region(m_SMBBA,10,"lm78");
    request_region(0x295,3,"lm78");

    
    //Just to make sure the LM78 is measuring
    outb( 0x40 , (unsigned short) 0x295 );
    outb( 0x01 , (unsigned short) 0x296 );
    
    return 0;
}

/* RMMOD ---------------------------------------------------------- */
void cleanup_module(void)
{

   proc_unregister(&proc_root,lm78_proc_entry.low_ino);

   release_region(m_SMBBA,10);
   release_region(0x295,3);
   release_region(0x0cf8,10);

   printk("lm78: done\n");

}

/*
 *
 * by ronald.schmitd@informatik.tu-chemnitz.de                        <ESC>:x
 ***************************************************************************/
