/*
 * wmjulia is a windowmaker / afterstep dock/wharf applet for GNU/Linux
 *
 * It draws spinning julia sets which can be adjusted with little buttons
 *
 * Code based on some of the Window maker programs found on the internet
 *
 * Code based on wmpong, by Dag Wieers <dag@digibel.be>
 *
 * Copyright 1999, Dave Turner (turnerd@reed.edu);
 *
 * This program is distributed under the GPL license. 
 *
 * Thanks to Richard Stallman for the GNU system and the GPL.
 * 
 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <time.h>
#include <math.h>

#include <X11/xpm.h>

#include "../wmgeneral/wmgeneral.h"

#include "wmjulia_master.xpm"

#define VERSION  "0.4"

#define USLEEP 20000

#ifndef PI
#define PI 3.1415926535897932384626
#endif

struct xpm_position
  {
    int x, y;
  };
struct xpm_surface
  {
    int x, y, w, h;
  };



struct xpm_position pos[] =
{
  {5, 50},
  {16, 50},
  {27, 50},
  {38, 50},
  {49, 50}
};
struct xpm_surface rel[] =
{
  {1, 70, 11, 9},
  {12, 70, 11, 9},
  {23, 70, 11, 9},
  {34, 70, 11, 9},
  {45, 70, 11, 9}
};
struct xpm_surface prs[] =
{
  {1, 79, 11, 9},
  {12, 79, 11, 9},
  {23, 79, 11, 9},
  {34, 79, 11, 9},
  {45, 79, 11, 9}
};


char wmjulia_pm[128][48];

extern GC NormalGC;

float spherewidth [48];
float tx [48];

/*****************************************************************************/
void init_sphere () {

  int i, j;

  for (i = 0; i < 48; i ++) {
    //not adjusted for width 48
    //spherewidth [i] = sqrt (sqrt (4096 - (abs (64 - i)) * (abs (64 - i)))) * 64;

    spherewidth [i] = (48 * 6.28) - sqrt (576 - (abs (24 - i)) * (abs (24 - i))) * 6.28;

    tx [i] = (-1.57 + acos (((float) i - 24) / 24)) / (2 * PI);

    for (j = 0; j < 48; j ++) {
      wmjulia_pm [i][j] = 0;
      wmjulia_pm [i + 48][j] = 0;
    }
  }
}
/*****************************************************************************/

void do_frame (double cx, double cy) {

  int x, y, x2, y2, i, done;

  double zx, zy, zx2, zy2;

  y2 = 47;
  for (y = 0; y < 47; y ++) {
   
    x2 = 57;
    for (x = 6; x < 32; x ++) {
      
      zx = ((float) (x - 32)) / 15;
      zy = ((float) (y - 24)) / 15;

      done = 0;

      for (i = 0; (i < 31) && (done == 0); i ++) {
	zx2 = zx * zx;
	zy2 = zy * zy;
	zy = 2 * zx * zy + cy;
	zx = zx2 - zy2  + cx;
	if (zx2 >= 4 || zy2 >= 4) done = 1;
      }
      wmjulia_pm [x][y] = i * 2;
      wmjulia_pm [x2][47 - y] = i * 2;

      x2 --;
    }

    y2 --;
  }

}
/*****************************************************************************/

void do_frame_wide (double cx, double cy) {

  int x, y, x2, y2, i, done;

  double zx, zy, zx2, zy2;

  y2 = 47;
  for (y = 0; y < 47; y ++) {
   
    x2 = 95;
    for (x = 0; x < 48; x ++) {
      
      zx = ((float) (x - 48)) / 24;
      zy = ((float) (y - 24)) / 15;

      done = 0;

      for (i = 0; (i < 31) && (done == 0); i ++) {

	zx2 = zx * zx;
	zy2 = zy * zy;
	zy = 2 * zx * zy + cy;
	zx = zx2 - zy2  + cx;

	if (zx2 >= 4 || zy2 >= 4) done = 1;
      }

      wmjulia_pm [x][y] = i * 2;
      wmjulia_pm [x2--][47 - y] = i * 2;
    }

    y2 --;
  }

}


/*****************************************************************************/

void paint_frame (int cmap) {

  // I really wish wmgeneral allowed a better way to implement this.
  // I tried to write one, but Xlib is too twisted for me at this time.

  int x, y;
  for (y = 47; y >= 0; y --) {
    for (x = 1; x < 63; x ++) {
      XCopyArea(display, wmgen.pixmap, wmgen.pixmap, NormalGC, cmap + 69, wmjulia_pm[x][y], 1, 1, x, y);
    }
  }
}

/*****************************************************************************/

void paint_frame_sphere (int cmap, int frame) {

  // I really wish wmgeneral allowed a better way to implement this.
  // I tried to write one, but Xlib is too twisted for me at this time.

  int x, y;
  int dist;

  for (y = 47; y >= 0; y --) {
    for (x = 8; x < 56; x ++) {

	dist = ((x - 32) * (x - 32) + (y - 24) * (y - 24)) >> 4;

	if (dist < 35) {

	  XCopyArea(display, wmgen.pixmap, wmgen.pixmap, NormalGC, cmap + 69, wmjulia_pm[(frame + ((int)(tx [x - 8] * spherewidth [y]))) % 96][y], 1, 1, x, y);

	}
    }
  }
}

/*****************************************************************************/

int main (int argc, char *argv[]) {
  XEvent Event;

  char wmjulia_mask_bits[64*64];
  int wmjulia_mask_width = 64;
  int wmjulia_mask_height = 64;

  double cx, cy, angle = 0;

  double speed = 0.05, radius = 0.95;

  int sphere_mode = 0;

  int frame = 0;

  int i;

  int cmap = 0;

  char *arg = NULL;

  createXBMfromXPM (wmjulia_mask_bits, wmjulia_master_xpm, wmjulia_mask_width, wmjulia_mask_height);
  openXwindow (argc, argv, wmjulia_master_xpm, wmjulia_mask_bits, wmjulia_mask_width, wmjulia_mask_height);

  for (i = 0; i < 5; i++)
    AddMouseRegion (i, pos[i].x, pos[i].y, pos[i].x + prs[i].w, pos[i].y + prs[i].h);

  AddMouseRegion (5, 0, 0, 64, 47);


  for (i = 1; i < argc; i ++) {
    arg = argv[i];
    
    if (*arg=='-') {
      switch (arg[1]) {
	
      case 'v' :
	printf ("%s\n", VERSION);
	exit (0);
        break;
       
      case 's':
	sphere_mode = 1;
	break;
      }
    }
  }

  init_sphere ();

  while (1) {
    angle += speed;
    cx = cos (angle) * radius;
    cy = sin (angle) * radius;

    if (speed > 0) {

      if (sphere_mode) {
	do_frame_wide (cx, cy);
	paint_frame_sphere (cmap, frame);
	frame ++;

      } else {

	do_frame (cx, cy);
	paint_frame (cmap);
      }

      RedrawWindow ();
    } else {
      usleep (USLEEP);
    }

    while (XPending (display)) {
      XNextEvent (display, &Event);
      switch (Event.type) {

      case Expose:
	RedrawWindow ();
	break;
      case DestroyNotify:
	XCloseDisplay (display);
	exit (0);
	break;
      case ButtonPress:
	i = CheckMouseRegion (Event.xbutton.x, Event.xbutton.y);
	copyXPMArea (prs[i].x, prs[i].y, prs[i].w, prs[i].h, pos[i].x, pos[i].y);
	switch (i)
	  {
	  case 0:
	    radius += 0.01;
            break;
	  case 1:
	    radius -= 0.01;
	    if (radius <= 0) radius = 0.01;
	    break;
	  case 2:
	    speed += 0.02;
	    break;
	  case 3:
	    speed -= 0.02;
	    if (speed < 0) speed = 0;
	    break;
	  case 4:
	    radius = 1;
	    speed = 0.04;
            break;
	  case 5:
	    cmap = (cmap + 1) % 8;

	    break;
	  }
	break;
      case ButtonRelease:
	i = CheckMouseRegion (Event.xbutton.x, Event.xbutton.y);
	copyXPMArea (rel[i].x, rel[i].y, rel[i].w, rel[i].h, pos[i].x, pos[i].y);
	break;
      }
    }
    usleep (USLEEP);
  }

  return 0;
}




