/*
    lmtest.c - A Linux program for reading sensor data.
    Copyright (c) 1997, 1998  Alexander Larsson <alla@lysator.liu.se>,
    Frodo Looijaard <frodol@dds.nl> and Philip Edelbrock <phil@netroedge.com>.


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <asm/io.h>
#include <unistd.h>
#include "lmtest.h"
#include "lm78.h"

/* Test_Busy:

Docs note that there is a possibility of the LM78 being busy with serial communication.  Before
altering anything, we should read the Address Register and check the highest order bit (used to
indicate that the device is busy).  */

int Test_Busy() {
  if (inb_p(LM78_ADDRESS_REG) & 0x0080) {
	printf("LM78: Busy!");
	return(1);
 }
 return(0);
}


/* main:

	This is where it all happens.  */

int main(int argc, char *argv[]) {
  int fan,i,j,k;
  
  ioperm(LM78_BASE,LM78_EXTENT,1);
  ioperm(0x80,1,1);

/* A busy event is rare enough that we can simple bail out if it is detected. */
  if (Test_Busy()) { return(1); }

  /* Reset all except Watchdog values and last conversion values
     This sets fan-divs to 2, and disables any NMI/IRQ or SMI interrupts */
  LM78_WRITE(LM78_CONFIG, 0x80 );

  /* Start monitoring */
  LM78_WRITE(LM78_CONFIG, (LM78_READ(LM78_CONFIG) & 0xf7) | 0x01);
 
  /* It can take upto 1.5 secs before it has scanned everything */
  sleep(2);

/* A busy event is rare enough that we can simple bail out if it is detected. */
  if (Test_Busy()) { return(1); }

  printf("config: 0x%02X\n", LM78_READ( 0x40 ) );
  printf("mask1: 0x%02X\n", LM78_READ( 0x43 ) );
  printf("mask2: 0x%02X\n", LM78_READ( 0x44 ) );
  printf("nmi mask1: 0x%02X\n", LM78_READ( 0x45 ) );
  printf("nmi mask2: 0x%02X\n", LM78_READ( 0x46 ) );
  printf("vid/fan: 0x%02X\n", LM78_READ( 0x47 ) );

  /* Ugly code, nice presentation */
  for (i=0; i<= 0x7f; i++) {
    if ((i & 0x0F)  == 0)
      printf("\nPost Ram/Value Ram(0x%02X):",i);
    printf(" %02X", LM78_READ( i ) );
  }
  printf("\n");

  printf("VID/Fan Divisor Register: 0x%02X\n", LM78_READ( LM78_FANDIV ) );
  printf("Serial bus address: 0x%02X\n", LM78_READ( 0x48 ) );

  i = LM78_READ(LM78_IN0);
  j = LM78_READ(LM78_IN0_MIN);
  k = LM78_READ(LM78_IN0_MAX);
  printf("IN0: %d (%2.2f)   Min: %d (%2.2f)  Max: %d (%2.2f)\n", i, i * 0.016 * NORMAL_0, j, j * 0.016 * NORMAL_0, k, k * 0.016 * NORMAL_0);
  i = LM78_READ(LM78_IN1);
  j = LM78_READ(LM78_IN1_MIN);
  k = LM78_READ(LM78_IN1_MAX);
  printf("IN1: %d (%2.2f)   Min: %d (%2.2f)  Max: %d (%2.2f)\n", i, i * 0.016 * NORMAL_1, j, j * 0.016 * NORMAL_1, k, k * 0.016 * NORMAL_1);
  i = LM78_READ(LM78_IN2);
  j = LM78_READ(LM78_IN2_MIN);
  k = LM78_READ(LM78_IN2_MAX);
  printf("IN2: %d (%2.2f)   Min: %d (%2.2f)  Max: %d (%2.2f)\n", i, i * 0.016 * NORMAL_2, j, j * 0.016 * NORMAL_2, k, k * 0.016 * NORMAL_2);
  i = LM78_READ(LM78_IN3);
  j = LM78_READ(LM78_IN3_MIN);
  k = LM78_READ(LM78_IN3_MAX);
  printf("IN3: %d (%2.2f)   Min: %d (%2.2f)  Max: %d (%2.2f)\n", i, i * 0.016 * NORMAL_3, j, j * 0.016 * NORMAL_3, k, k * 0.016 * NORMAL_3);
  i = LM78_READ(LM78_IN4);
  j = LM78_READ(LM78_IN4_MIN);
  k = LM78_READ(LM78_IN4_MAX);
  printf("IN4: %d (%2.2f)   Min: %d (%2.2f)  Max: %d (%2.2f)\n", i, i * 0.016 * NORMAL_4, j, j * 0.016 * NORMAL_4, k, k * 0.016 * NORMAL_4);
  i = LM78_READ(LM78_IN5);
  j = LM78_READ(LM78_IN5_MIN);
  k = LM78_READ(LM78_IN5_MAX);
  printf("-IN5: %d (%2.2f)   Min: %d (%2.2f)  Max: %d (%2.2f)\n", i, -i * 0.016 * NORMAL_5, j, -j * 0.016 * NORMAL_5, k, -k * 0.016 * NORMAL_5);
  i = LM78_READ(LM78_IN6);
  j = LM78_READ(LM78_IN6_MIN);
  k = LM78_READ(LM78_IN6_MAX);
  printf("-IN6: %d (%2.2f)   Min: %d (%2.2f)  Max: %d (%2.2f)\n", i, -i * 0.016 * NORMAL_6, j, -j * 0.016 * NORMAL_6, k, -k * 0.016 * NORMAL_6);

  printf("----------\n");
  printf("Mb_temp: %d\n", LM78_READ( LM78_TEMPERATURE ) );

  fan = LM78_READ( LM78_FAN1 );
  printf("Fan1: ");
  if (fan==255)
    printf( "0 rpm\n" );
  else
    printf("%d rpm\n", LM78_RPM(fan,2) );

  fan = LM78_READ( LM78_FAN2 );
  printf("Fan2: ");
  if (fan==255)
    printf( "0 rpm\n" );
  else
    printf("%d rpm\n", LM78_RPM(fan,2) );

  fan = LM78_READ( LM78_FAN3 );
  printf("Fan3: ");
  if (fan==255)
    printf( "0 rpm\n" );
  else
    printf("%d rpm\n", LM78_RPM(fan,2) );
  exit(0);

}

