/*
    lm78.h - Header file for the Linux sensor programs
    Copyright (c) 1997, 1998  Alexander Larsson <alla@lysator.liu.se>,
    Frodo Looijaard <frodol@dds.nl> and Philip Edelbrock <phil@netroedge.com>.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* Heavily patched by Frodo Looijaard <frodol@dds.nl> and Philip Edelbrock
   (phil@Stimpy.netroedge.com). */

#ifndef LM78_H
#define LM78_H

#include <asm/io.h>
#include "smbus.h"


#define LM78_BASE 0x290
#define LM78_EXTENT 0x8
#define LM78_ADDRESS_REG (LM78_BASE + 0x5)
#define LM78_DATA_REG (LM78_BASE + 0x6)

#define LM78_BUSY ( inb_p( LM78_ADDRESS_REG ) & (1<<7) )

#define LM78_DUMMY 0x20

#define LM78_READ(addr) ({ \
outb_p((addr),LM78_ADDRESS_REG); \
inb_p(LM78_DATA_REG); \
})

#define LM78_WRITE(addr,x)  \
outb_p( (addr), LM78_ADDRESS_REG ); \
outb_p( (x), LM78_DATA_REG )

#define LM78_SMBUS_WRITE(reg, value ) SMBus_Write_Byte_Data(smbus_addr,reg,value)


#define LM78_SMBUS_READ(reg) SMBus_Read_Byte_Data(smbus_addr,reg)


/* address constants within LM78 RAM */
#define LM78_IN0 0x20     
#define LM78_IN1 0x21     
#define LM78_IN2 0x22     
#define LM78_IN3 0x23     
#define LM78_IN4 0x24     
#define LM78_IN5 0x25
#define LM78_IN6 0x26     
#define LM78_TEMPERATURE 0x27
#define LM78_FAN1 0x28
#define LM78_FAN2 0x29
#define LM78_FAN3 0x2A
#define LM78_IN0_MAX 0x2b
#define LM78_IN0_MIN 0x2c
#define LM78_IN1_MAX 0x2d
#define LM78_IN1_MIN 0x2e
#define LM78_IN2_MAX 0x2f
#define LM78_IN2_MIN 0x30
#define LM78_IN3_MAX 0x31
#define LM78_IN3_MIN 0x32
#define LM78_IN4_MAX 0x33
#define LM78_IN4_MIN 0x34
#define LM78_IN5_MAX 0x35
#define LM78_IN5_MIN 0x36
#define LM78_IN6_MAX 0x37
#define LM78_IN6_MIN 0x38
#define LM78_TEMPERATURE_MAX 0x39
#define LM78_TEMPERATURE_MIN 0x3a
#define LM78_FAN1_MIN 0x3b
#define LM78_FAN2_MIN 0x3c
#define LM78_FAN3_MIN 0x3d

/* addresses of LM78 registers */
#define LM78_VID 0x47
#define LM78_INTSTAT1 0x41
#define LM78_INTSTAT2 0x42
#define LM78_CONFIG 0x40
#define LM78_FANDIV 0x47
#define LM78_SMBUSADDR 0x48
#define LM78_RESET 0x49

/* addresses of WINBOND specific registers */
#define LM78_WINB_SMBADDR 0x4a
#define LM78_WINB_PIN 0x4b
#define LM78_WINB_FANCONT 0x4d
#define LM78_WINB_BANK 0x4e
#define LM78_WINB_ID 0x4f
#define LM78_WINB_BEEP2 0x57

/* Note about the winbond chip: to set bank n (0<=n<=2), write n*2 to the
   low 3 bits of LM78_WINB_BANK! */

/* address constants within LM80 RAM */
#define LM80_IN0 0x20
#define LM80_IN1 0x21
#define LM80_IN2 0x22
#define LM80_IN3 0x23
#define LM80_IN4 0x24
#define LM80_IN5 0x25
#define LM80_IN6 0x26
#define LM80_TEMPERATURE 0x27
#define LM80_FAN1 0x28
#define LM80_FAN2 0x29
#define LM80_IN0_MIN 0x2a
#define LM80_IN0_MAX 0x2b
#define LM80_IN1_MIN 0x2c
#define LM80_IN1_MAX 0x2d
#define LM80_IN2_MIN 0x2e
#define LM80_IN2_MAX 0x2f
#define LM80_IN3_MIN 0x30
#define LM80_IN3_MAX 0x31
#define LM80_IN4_MIN 0x32
#define LM80_IN4_MAX 0x33
#define LM80_IN5_MIN 0x34
#define LM80_IN5_MAX 0x35
#define LM80_IN6_MIN 0x36
#define LM80_IN6_MAX 0x37
#define LM80_TEMPERATURE_MAX 0x38 /* We will not use OS temperature! */
#define LM80_TEMPERATURE_MIN 0x39
#define LM80_FAN1_MIN 0x3c
#define LM80_FAN2_MIN 0x3d


/* Other LM80 registers */

#define LM80_CONFIG 0x00
#define LM80_INTSTAT1 0x01
#define LM80_INTSTAT2 0x02
#define LM80_FANDIV 0x05

/* Calculate rpms from tacho-count */
#define LM78_RPM(count,div) (((count)==0)?999999:((count)==255)?0:(1350000 + (count*div/2))/((count)*(div)))

/* Calculate tacho-count from rpms */
#define LM78_FAN_COUNT(rpm,div) (((rpm)==0)?255:((1350000+rpm*div/2)/((rpm)*div)))

/* These defines are used by LM78_Set and LM78_Get */
#define LM_PROBE_IN 1        /* Values multiplied by 100 */
#define LM_PROBE_IN_MIN 2
#define LM_PROBE_IN_MAX 3
#define LM_PROBE_FAN 4       /* Values not multiplied */
#define LM_PROBE_FAN_MIN 5
#define LM_PROBE_TEMP 6      /* Values multiplied by 10 */
#define LM_PROBE_TEMP_MIN 7
#define LM_PROBE_TEMP_MAX 8
#define LM_PROBE_VID 9       /* Values multiplied by 100 */
#define LM_PROBE_ALARM 10    /* Values in bitvector */
#define LM_PROBE_FAN_DIV 11  /* Values 1, 2, 4 or 8 */

#define LMTYPE_UNKNOWN 0
#define LMTYPE_78 1
#define LMTYPE_78_J 2
#define LMTYPE_79 3
#define LMTYPE_WINB 4
#define LMTYPE_80 5

EXTERN struct semaphore LM78_Sem;
EXTERN int LM_Type;
EXTERN int LM78_SMBus;

#endif /* LM78_H */

