/*
    lm75.h - A Linux program for reading sensor data.
    Copyright (c) 1997, 1998  Alexander Larsson <alla@lysator.liu.se>,
    Frodo Looijaard <frodol@dds.nl> and Philip Edelbrock <phil@netroedge.com>.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef LM75_H
#define LM75_H

#define LM_PROBE_LM75_OS 0
#define LM_PROBE_LM75_HYST 1
#define LM_PROBE_LM75_VALUE 2
#define LM_PROBE_LM75_CONFIG 3
#define Tos_DEFAULT 50
#define Thyst_DEFAULT 45

/* The LM75_?_VAL tell us the expected voltage * 10. It is used to set
   the initial limits. Note that we still hardcore the VCore stuff here */

/* If ..._STRING is not defined, the input will be completely ignored */

# define LM75_0_STRING "LM75-0"
# define LM75_0_VAL    400
# define LM75_1_STRING "LM75-1"
# define LM75_1_VAL    400
# define LM75_2_STRING "LM75-2"
# define LM75_2_VAL    400
# define LM75_3_STRING "LM75-3"
# define LM75_3_VAL    400
# define LM75_4_STRING "LM75-4"
# define LM75_4_VAL    400
# define LM75_5_STRING "LM75-5"
# define LM75_5_VAL    400
# define LM75_6_STRING "LM75-6"
# define LM75_6_VAL    400
# define LM75_7_STRING "LM75-7"
# define LM75_7_VAL    400

#endif /* LM75_H */
