/* An example program for the use of the sysctl interface. This file is
   completely freeware; do whatever you like with it. Note that this
   is the only file in this package for which this is true! */

/* Note that you must be root to use this program, as we try to write
   new values! */

/* Change this to <../lm_sensors.h> if you want to test without installing */
#include <linux/lm_sensors.h>

#include <unistd.h>
#include <linux/unistd.h>
#include <linux/sysctl.h>

/* The file to access. See for constants linux/sysctl.h and linux/lm_sensors.h.
   It means: access /dev/lm_sensors/config-fan-labels */
int name[]={CTL_DEV,DEV_LMT,LMT_FAN_LABELS};

/* The number of entries in name */
int namelen = 3;

/* A buffer for reading the old values. If it is too small, the result will
   simply be truncated. */
char oldval[150];

/* The length of the buffer, and later on the number of bytes put into 
   oldval */
size_t oldlen = sizeof(oldval);

/* A buffer containing the new values. Just like the /proc interface, if
   you specify only a few entries, all others remain the same. */
char newval[]={"VOLT1 NR2"};

/* The number of valid bytes in the buffer */
size_t newlen = sizeof(newval);


int main() { 
  int error;
  /* If oldval or newval is NULL, nothing is done with them. That way, you
     can read without writing, or write without reading. */
  error=sysctl(name,namelen,(void *) oldval, &oldlen, newval,newlen);
  if (error) 
    printf("sysctl(): %s\n",strerror(errno));
  else {
    printf("Length: %d bytes\n",oldlen);
    printf("%s\n",oldval);
  }
  exit(0);
}
  
