/*
 * WMGrav
 * Based on wmtest distributed with Window Maker (http://www.windowmaker.org/)
 * 
 * This code is in the public domain, but there are ABSOLUTELY NO
 * WARRANTIES OF ANY TYPE WHATSOEVER, WHEREVER YOU ARE, WHATEVER ARE
 * THE LAWS THERE AND WHATEVER HAPPENS TO YOU BY USING THIS CODE.
 * This code is distributed under the GNU Public Licence
 */


#include <dockapp.h>
#include <unistd.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#define WINDOW_SIZE 56

int points=4;
int lineLen=40;
int delay=10;
int energy=6;
char *Sdrain = "0.9";
float drain;

char *displayName = "";

static DAProgramOption options[] = {
    {"-p", "--points", "number of points (default 4)", DOInteger, False, 
     {&points}},
    {"-l", "--length", "line length (default 40)", DOInteger, False, {&lineLen}},
    {"-d", "--delay", "delay per frame (default 10)", DOInteger, False, {&delay}},
    {"-e", "--energy", "point initial energy (default 6, max 24)", DOInteger, False,
     {&energy}},
    {"-s", "--drain", "bounce energy drain (default 0.9)", DOString, False, {&Sdrain}}
};

int getop(float *old_xp, int p, int l)
{
  return old_xp[p + (l*lineLen)];
}

void setop(float *old_xp, int p, int l, float v)
{
  old_xp[p + (l*lineLen)] = v;
}

int
main(int argc, char **argv)
{
    Pixmap pixmap;
    GC gc;
    int x, y, ptr=lineLen-1, optr=0;
    float *xp, *yp, *xm, *ym;
    float *old_xp, *old_yp;

    DAParseArguments(argc, argv, options,
		     sizeof(options)/sizeof(DAProgramOption),
		     "wmGrav by Ian Clarke", "wmGrav 1.3");
    xp = calloc(points, sizeof(float));
    yp = calloc(points, sizeof(float));
    xm = calloc(points, sizeof(float));
    ym = calloc(points, sizeof(float));
    old_xp = calloc(points * lineLen, sizeof(float));
    old_yp = calloc(points * lineLen, sizeof(float));
    sscanf(Sdrain, "%f", &drain);
    if (energy > 24)
      {
	fprintf(stderr, "Warning: energy >%d will have no additional effect\n",
		WINDOW_SIZE/2);
	energy=WINDOW_SIZE/2;
      }

    DAInitialize(displayName, "WMGrav", WINDOW_SIZE, WINDOW_SIZE, argc, argv);

    pixmap = DAMakePixmap();
    gc = DefaultGC(DADisplay, DefaultScreen(DADisplay));

    DAShow();

    /* Set initial point positions */
    for(x=0; x<points; x++)
     { 
       xp[x]=(random() % energy) + (WINDOW_SIZE/2); 
       yp[x]=(random() % energy) + (WINDOW_SIZE/2);
     }

    /* Set initial momentums to 0 */
    for(x=0; x<points; x++)
      {
	xm[x] = 0; ym[x] = 0;
      }

    XSetForeground(DADisplay, gc, 
		   BlackPixel(DADisplay, DefaultScreen(DADisplay)));
    XFillRectangle(DADisplay, pixmap, gc, 0, 0, WINDOW_SIZE, WINDOW_SIZE);
	
    while (1) {
	XEvent ev;

	XSetForeground(DADisplay, gc, 
		       WhitePixel(DADisplay, DefaultScreen(DADisplay)));
	/* Draw the points */
	for (x=0; x<points; x++)
	  {
	    XDrawPoint(DADisplay, pixmap, gc, (int) xp[x], (int) yp[x]);
	    if (ptr == lineLen)
	      ptr = 0;
	    if (optr == lineLen)
	      optr = 0;
	    setop(old_xp, ptr, x, xp[x]);
	    setop(old_yp, ptr, x, yp[x]);
	  }
	XSetForeground(DADisplay, gc, 
		       BlackPixel(DADisplay, DefaultScreen(DADisplay)));
	for (x=0; x<points; x++)
	  {
	    XDrawPoint(DADisplay, pixmap, gc, (int) getop(old_xp,optr,x), 
		       (int) getop(old_yp,optr,x));
	  }
	ptr++;
	optr++;
	/* Draw cosmetic lines to give 3d effect */
	XSetForeground(DADisplay, gc, 
		       WhitePixel(DADisplay, DefaultScreen(DADisplay)));
	for (x=0; x<WINDOW_SIZE; x+=2)
	  {
	    XDrawPoint(DADisplay, pixmap, gc, WINDOW_SIZE-1, x);
	    XDrawPoint(DADisplay, pixmap, gc, x, WINDOW_SIZE-1);
	  }
	DASetPixmap(pixmap);

	/* Update momentums */
	for (x=0; x<points; x++)
	  {
	    for (y=0; y<points; y++)
	      {
		if ((y != x) && ((xp[x] != xp[y]) || (yp[x] != yp[y])))
		  {
		    if (xp[x] != xp[y])
		      xm[x] += ((float) (xp[y] - xp[x])) / (float)
			(((xp[x] - xp[y]) * (xp[x] - xp[y])) +
			 ((yp[x] - yp[y]) * (yp[x] - yp[y])));
		    
		    if (yp[x] != yp[y])
		      ym[x] += ((float) (yp[y] - yp[x])) / (float) 
			(((xp[x] - xp[y]) * (xp[x] - xp[y])) +
			 ((yp[x] - yp[y]) * (yp[x] - yp[y])));
		  }
	      }
	    if (xp[x] < 0)
	      xm[x] = abs(xm[x]) * drain;
	    if (yp[x] < 0)
	      ym[x] = abs(ym[x]) * drain;
	    if (xp[x] > WINDOW_SIZE)
	      xm[x] = -abs(xm[x]) * drain;
	    if (yp[x] > WINDOW_SIZE)
	      ym[x] = -abs(ym[x]) * drain;
	  
	  }

	/* Update positions */
	for (x=0; x<points; x++)
	  {
	    xp[x] += xm[x] / 40.0;
	    yp[x] += ym[x] / 40.0;
	  }

	/* handle all pending X events */
	while (XPending(DADisplay)) {
	    XNextEvent(DADisplay, &ev);
	    DAProcessEvent(&ev);
	}

	usleep(delay);
    }

    return 0;
}

