/*     WMBeats 1.2  -  Internet Time in a Window Maker Dock
 *     Copyright (C) 1999 Pascal Hofstee <daeron@shadowmere.student.utwente.nl>
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *	   (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ***************************************************************************/

#include <dockapp.h>
#include <unistd.h>
#include <time.h>
#include "wmbeats.xpm"


/* TypeDefs */

typedef enum {
	ITime,
	UTC_Local
} PanelMode;

/* End of TypeDefs */

char *displayName = "";
char *fontName = "";

char *monthName[12] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

PanelMode panelmode = ITime;


static DAProgramOption options[] = {
	{"-d", "--display", "display to use", DOString, False, {&displayName} },
	{"-fn", "--font", "font to use", DOString, False, {&fontName} },
	{"-u", "--utclocal", "start in UTC-Local mode", DONone, False, {NULL} },
	{"-i", "--itime", "start in ITime (Beats) mode", DONone, False, {NULL} }
};


static void
changePanel(int button, int state, int x, int y)
{
	switch (panelmode)
	{
		case ITime:
			panelmode = UTC_Local;
			break;
		case UTC_Local:
			panelmode = ITime;
			break;
	}
}


static void
paintITime(Pixmap pixmap, Pixmap backdrop, GC gc)
{
	struct	tm *clk;
	long	curtime;
	float	itime;
	int		subbeats;
	char	buf[10];

	curtime = time(0);
	clk = gmtime(&curtime);
	itime = (((clk->tm_hour + 1) * 3600*1000) + (clk->tm_min*60*1000) + (clk->tm_sec*1000)) / 86400.0;
	if (clk->tm_hour == 23)
		itime -= 1000;

	subbeats = 1000*(itime - (int)(itime));
	sprintf(buf, "%03i", (int)itime);

	XCopyArea(DADisplay, backdrop, pixmap, gc, 0, 0, 48, 48, 0, 0);
	
	XSetForeground(DADisplay, gc, 
				WhitePixel(DADisplay, DefaultScreen(DADisplay)));
	XDrawString(DADisplay, pixmap, gc, 28, 16, buf, strlen(buf));

	sprintf(buf, ".%03i", subbeats);

	XDrawString(DADisplay, pixmap, gc, 22, 44, buf, strlen(buf));
}

static void
paintUTCLocal(Pixmap pixmap, GC gc)
{
	struct	tm	*clk, *localclk;
	long	curtime;
	char	buf[10];
	
	XSetForeground(DADisplay, gc,
	BlackPixel(DADisplay, DefaultScreen(DADisplay)));
	XFillRectangle(DADisplay, pixmap, gc, 0, 0, 48, 48);
		
	XSetForeground(DADisplay, gc, 
	WhitePixel(DADisplay, DefaultScreen(DADisplay)));


	curtime = time(0);
	clk = gmtime(&curtime);
	localclk = localtime(&curtime);
	
	sprintf(buf, "%2i:%02i:%02i", clk->tm_hour, clk->tm_min, clk->tm_sec);
	XDrawString(DADisplay, pixmap, gc, 3, 14, buf, strlen(buf));

	if (!(localclk->tm_hour == clk->tm_hour)) {
		sprintf(buf, "%2i:%02i:%02i", localclk->tm_hour, localclk->tm_min, localclk->tm_sec);
		XDrawString(DADisplay, pixmap, gc, 4, 29, buf, strlen(buf));
	}
	else {
	   sprintf(buf, "-==-");
		XDrawString(DADisplay, pixmap, gc, 13, 29, buf, strlen(buf));
	}

	sprintf(buf, "%s %2i", monthName[clk->tm_mon], clk->tm_mday);
	XDrawString(DADisplay, pixmap, gc, 8, 44, buf, strlen(buf));
}

int
main(int argc, char **argv)
{
	GC gc;
	Pixmap	pixmap;
	Pixmap	backdrop;
	Font	font;
	static unsigned d_width = 48;
	static unsigned d_height = 48;
	DACallbacks callbacks={NULL, changePanel, NULL, NULL, NULL, NULL};

	/* Parse CommandLine */
	DAParseArguments(argc, argv, options,
				sizeof(options)/sizeof(DAProgramOption),
				"WMBeats", "WMBeats v1.2");

	/* Initialize Application */
	DAInitialize(displayName, "WMBeats", d_width, d_height, argc, argv);

	DAMakePixmapFromData(wmbeats_xpm, &backdrop, None, &d_width, &d_height);
	pixmap = DAMakePixmap();
	gc = DefaultGC(DADisplay, DefaultScreen(DADisplay));

	if (strlen(fontName) == 0) {
		font = XLoadFont(DADisplay, "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*");
	}
	else {
	   font = XLoadFont(DADisplay, fontName);
	}
	XSetFont(DADisplay, gc, font);
	XUnloadFont(DADisplay, font);

	/* Initialize Clock Mode */
	if (options[2].used) {
	   panelmode = UTC_Local;
	}
	else if (options[3].used) {
	   panelmode = ITime;
	}

	/* Initialize Callbacks */
	DASetCallbacks(&callbacks);

	/* Activate Application */
	DAShow();

	while (1) {
		XEvent ev;
		
		switch (panelmode)
		{
			case ITime:
				paintITime(pixmap, backdrop, gc);
				break;
			case UTC_Local:
				paintUTCLocal(pixmap, gc);
				break;
		}
		
		DASetPixmap(pixmap);

		/* handle all pending X events */
		while (XPending(DADisplay)) {
		   	XNextEvent(DADisplay, &ev);
		    DAProcessEvent(&ev);
		}
		usleep(25000);
	}

	return 0;
}

