/*
 ****************************************************************
 *
 * Copyright (C) 1998,1999 Atsushi Umeshima <ume@tka.att.ne.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************
 */

#include <stdio.h>
#include <string.h>
#include <getopt.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/un.h>

#include "amfm.h"

#define NAME "wmamfmctl"
#define VERSION "1.1.1"

int radio_status=-1;
int radio_band=-1;
char volstr[16];
char freqstr[16];
char *name;
char *short_opts = "hnfv:s:c:a";
struct option long_opts[] =
{
    {"help", 0, 0, 'h'},
    {"on", 0, 0, 'n'},
    {"off", 0, 0, 'f'},
    {"vol", 1, 0, 'v'},
    {"fm", 1, 0, 's'},
    {"am", 1, 0, 'c'},
    {"another", 0, 0, 'a'},
    {NULL, 0, 0, 0}
};
struct sockaddr_un server;
int cli_sock;
char *myname;
int indx = 0;

void parse_command_line(int argc, char *argv[]);
void usage(void);
void send_command(char *w_str);
void version(void);

int main(int argc, char *argv[])
{
    char cmd[16];
    
    myname = argv[0];
    memset(volstr, 0, 16);
    memset(freqstr, 0, 16);
    name = argv[0];
    if ( argc == 1 ) { 
        usage();
        exit(0);
    }
    parse_command_line(argc,argv);
    
    strcpy(server.sun_path, SOCK_NAME);
    if(indx != 0)
      {
	strcat(server.sun_path, "1");
      }
    server.sun_family = AF_UNIX;
    
    if((radio_band != -1) && (freqstr[0] != 0))
    {
	memset(cmd, 0, 16);
	if(radio_band == AM)
            strcpy(cmd, STR_AM);
	else
            strcpy(cmd, STR_FM);
	strcat(cmd, " ");
	strncat(cmd, freqstr, sizeof(cmd)-sizeof(STR_FM)-2);
	send_command(cmd);
    }
    if(volstr[0] != 0)
    {
	memset(cmd, 0, 16);
	strcpy(cmd, STR_VOL);
	strcat(cmd, " ");
	strncat(cmd, volstr, sizeof(cmd)-sizeof(STR_VOL)-2);
	send_command(cmd);
    }
    if(radio_status != -1)
    {
	memset(cmd, 0, 16);
	if(radio_status == ON)
            strcpy(cmd, STR_ON);
	else
            strcpy(cmd, STR_OFF);
	send_command(cmd);
    }
    exit(0);
}

void send_command(char *w_str)
{
    char r_str[16];
    
    if((cli_sock = socket(AF_UNIX, SOCK_STREAM, 0)) == -1)
    {
        perror("Error in socket");
        exit(1);
    }
    if(connect(cli_sock, (struct sockaddr *) &server,
               strlen(server.sun_path)+sizeof(server.sun_family)) == -1)
    {
        perror("wmamfm not running");
        exit(1);
    }
    if(write(cli_sock, w_str, strlen(w_str)) != -1)
    {
#ifdef DEBUG
        printf("<<< %s\n", w_str);
#endif
        memset(r_str, 0, 16);
        if(read(cli_sock, r_str, 16) == -1)
	{
            perror("Error in read");
            exit(0);
	}
#ifdef DEBUG
        printf(">>> %s\n", r_str);
#endif
    }
    else
    {
        perror("Error in write");
        exit(0);
    }
    close(cli_sock);
}

void parse_command_line(int argc, char *argv[])
{
    int opt_index = 0, c;
    
    while ((c = getopt_long(argc, argv, short_opts, long_opts, &opt_index)) != EOF) {
        switch( c ) {
            case 'h':
                usage();
                exit(0);
                break;
            case 'n':
                radio_status = ON;
                break;
            case 'f':
                radio_status = OFF;
                break;
            case 's':
                radio_band = FM;
                strncpy(freqstr, optarg, sizeof(freqstr)-1);
                break;
            case 'c':
                radio_band = AM;
                strncpy(freqstr, optarg, sizeof(freqstr)-1);
                break;
	    case 'v':
                strncpy(volstr, optarg, sizeof(volstr)-1);
                break;
	    case 'a':
                indx = 1;
                break;
            default:
                exit(1);
        }
    }
}

void usage(void)
{
    version();
    printf("\n");
    printf("Usage: %s [OPTIONS]\n", myname);
    printf("\n");
    printf("  -n, --on                       "
           "turn radio on\n");
    printf("  -f, --off                      "
           "turn radio off\n");
    printf("  -s, --fm                       "
           "FM station to tune, ie 76.1\n");
    printf("  -c, --am                       "
           "AM channel to tune, ie 1134\n");
    printf("  -v, --vol                      "
           "set volume 0-100\n");
    printf("  -a, --another                      "
           "communicate with second instance of wmamfm\n");
    printf("  -h, --help                     "
           "display this help and exit\n");
    printf("\n");
    printf("Author: Atsushi Umeshima <ume@tka.att.ne.jp>\n");
    printf("   Web: http://members.xoom.com/ume/amfm.html\n");
}

void version(void)
{
  printf("This is " NAME " " VERSION " for wmamfm 1.1.x\n");
  printf("Copyright (C) 1998,1999 Atsushi Umeshima\n");
}

