/* serial control routines for *amfm -  Linux interface for
   GemTek based radio module(ex. Justy Radion-maru) attached to a serial port.
   The bulk of the following code was by Chris Radek,
   but lightly modified by Atsushi Umeshima <ume@tka.att.ne.jp> 
   see *amfm.c for GNU copyleft statement */

#include <termios.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <errno.h>

#include "amfm.h"

#define _POSIX_SOURCE 1 /* POSIX compliant source */

int openradio(char *device)
{
  int fd;
  struct termios newtio;

  fd = open(device, O_RDWR | O_NOCTTY | O_NONBLOCK);
  if (fd <0)
  {
      if(errno == EINTR)
      {
#ifdef DEBUG
          perror(device);
#endif
          return fd;
      }
      else
      {
          perror(device);
          exit(-1);
      }
  }
  
#ifdef DEBUG
  printf("%s opened.\nFile descriptor %d.\n",device,fd);
#endif

  newtio.c_cflag = B9600 | CS8 | CLOCAL;
  newtio.c_iflag = IGNPAR | IGNBRK;
  newtio.c_oflag = 0;
  newtio.c_lflag = 0;
  newtio.c_cc[VMIN]=1;
  newtio.c_cc[VTIME]=0;
  tcsetattr(fd,TCSANOW,&newtio);

  return fd;
}

void clearrts(int fd) {
  unsigned short arg = TIOCM_RTS;
  ioctl(fd,TCFLSH,2);
  if(ioctl(fd,TIOCMBIC,&arg)==-1) {
    fprintf(stderr,"%s\n",strerror(errno));
    exit(1);
  }
}

void setrts(int fd) {
  unsigned short arg = TIOCM_RTS;
  ioctl(fd,TCFLSH,2);
  if(ioctl(fd,TIOCMBIS,&arg)==-1) {
    fprintf(stderr,"%s\n",strerror(errno));
    exit(1);
  }
}

void cleardtr(int fd) {
  unsigned short arg = TIOCM_DTR;
  ioctl(fd,TCFLSH,2);
  if(ioctl(fd,TIOCMBIC,&arg)==-1) {
    fprintf(stderr,"%s\n",strerror(errno));
    exit(1);
  }
}

void setdtr(int fd) {
  unsigned short arg = TIOCM_DTR;
  ioctl(fd,TCFLSH,2);
  if(ioctl(fd,TIOCMBIS,&arg)==-1) {
    fprintf(stderr,"%s\n",strerror(errno));
    exit(1);
  }
}

void closeradio(int fd) {
#ifdef DEBUG
  printf("Closing port...\n");
#endif
  close(fd);
  exit(0);
}
