/* radio control routines for *amfm -  Linux interface for
   GemTek based radio module(ex. Justy Radion-maru) attached to a serial port.
   The bulk of the following code was by Chris Radek,
   but lightly modified by Atsushi Umeshima <ume@tka.att.ne.jp>
   see *amfm.c for GNU copyleft statement */

#include <sys/time.h>
#include "amfm.h"

#define SELECT_USEC 100000

int radioinit(char *device) {
#ifndef NORADIO
  int fd;
  fd = openradio(device);
#ifdef DEBUG
  fprintf(stderr,"openradio() returns %d\n",fd);
#endif
  if (fd <0)
  {
      fprintf(stderr,"Cannot open %s\n",device);
      exit(1);
  }
#ifdef DEBUG
  fprintf(stderr,"setting rts bit\n");
#endif
  setrts(fd);
#ifdef DEBUG
  fprintf(stderr,"setting dtr bit\n");
#endif
  setdtr(fd);
  tcflush(fd, TCIOFLUSH);
  return(fd);
#else
  return 0;
#endif
}

void radioon(int fd) {
#ifndef NORADIO
#ifdef DEBUG
  fprintf(stderr,"Writing ON\n");
#endif
  setrts(fd);
  setdtr(fd);
  write(fd, RADIOON, RADIOONSIZE);
#endif
}

void radiooff(int fd) {
#ifndef NORADIO
#ifdef DEBUG
  fprintf(stderr,"Writing OFF\n");
#endif
  write(fd, RADIOOFF, RADIOOFFSIZE);
#endif
}

void radioclose(int fd) {
#ifndef NORADIO
#ifdef DEBUG
  fprintf(stderr,"closing fd %d\n", fd);
#endif
  close(fd);
#endif
}

void radiotune(int fd, char *channel, int band) {
#ifndef NORADIO
  int slen = strlen(channel);
#ifdef DEBUG
  if (slen != 3) 
      fprintf(stderr,"tuning to bogus channel \"%s\"!!\n", channel);
  fprintf(stderr,"tuning to channel \"%s\" using fd %d\n", channel, fd);
#endif
  if (band == AM) {
      write(fd, AMTUNE, AMTUNESIZE);
  } else {
      write(fd, FMTUNE, FMTUNESIZE);
  }
  write(fd, channel, slen);
#endif
}

int radioprobe(int fd) {
#ifndef NORADIO
  char buf[5];
  int ret;
  fd_set rfds;
  struct timeval tv_cua;
  
  tcflush(fd, TCIOFLUSH);
#ifdef DEBUG
  fprintf(stderr,"Writing ENQ\n");
#endif
  lseek(fd, 0, SEEK_END);
  write(fd, RADIOENQ, RADIOENQSIZE);
  FD_ZERO(&rfds);
  FD_SET(fd, &rfds);
  tv_cua.tv_sec = 0;
  tv_cua.tv_usec = SELECT_USEC;  
  buf[0] = buf[1] = buf[2] = buf[3] = buf[4] = 0;
  if(select(fd+1, &rfds, (fd_set *)0, (fd_set *)0, &tv_cua) == -1)
  {
      perror("Error in select\n");
  }
  
  if (FD_ISSET(fd, &rfds))
  {
      read(fd, buf, RADIOACKSIZE);
      buf[4]=0;
      ret = strcmp(buf, RADIOACK);
      if(ret)
      {
	  ret = strcmp(buf, RADIOACK2);
      }
#ifdef DEBUG
      fprintf(stderr,"buf = %02x %02x %02x %02x\n", buf[0], buf[1], buf[2], buf[3]);
      fprintf(stderr,"Radio %sfound.\n", ret ? "not " : "");
#endif
      return ret;
#else
      return 0;
#endif
  }
#ifdef DEBUG
  fprintf(stderr,"Radio not found.\n");
#endif
  return 1;
}
