/* mixer control routines for *amfm - Linux interface for
   GemTek based radio module(ex. Justy Radion-maru) attached to a serial port.
   The bulk of following code was by Chris Radek.
   but lightly modified by Atsushi Umeshima <ume@tka.att.ne.jp>
   see *amfm.c for GNU copyleft statement */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/soundcard.h>

int openmixer(int indx) {
#ifndef NOMIXER
  int fd;
  
  if(indx==1)
    fd = open("/dev/mixer1", O_RDWR);
  else
    fd = open("/dev/mixer", O_RDWR);
  if (fd<0) perror("open");
  return fd;
#else
  return 0;
#endif
}

void setvolume(int fd, unsigned int value) {
#ifndef NOMIXER
  value = (value<<8)|value;
  if (fd>=0)
  {
      if (ioctl(fd, SOUND_MIXER_WRITE_LINE, &value)<0) perror("ioctl write");
  }
#endif
}

int getvolume(int fd) {
#ifndef NOMIXER
  int value;
  if (fd>=0)
  {
      if (ioctl(fd, SOUND_MIXER_READ_LINE, &value)<0) perror("ioctl read");
  } else {
      value = 0;
  }
  return ( ((value&0xff)+(value>>8)) /2 );
#else
  return 0;
#endif
}

void closemixer(int fd) {
#ifndef NOMIXER
  if (fd>=0)
  {
      close(fd);
  }
#endif
}

void addrecsrc(int fd, int src) {
#ifndef NOMIXER
  int value;
    
  if (fd>=0)
  {
      if (ioctl(fd, SOUND_MIXER_READ_RECSRC, &value)<0) perror("ioctl read");
      value |= (1<<src);
      if (ioctl(fd, SOUND_MIXER_WRITE_RECSRC, &value)<0) perror("ioctl write");
  }
#endif
}
