#include <termios.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/soundcard.h>

#define BAUDRATE B9600
#define DEVICE "/dev/radio"
#define SOCK_NAME "/tmp/.wmamfm"

#define RADIOON    "\x1d\x23\x01\x23"
#define RADIOONSIZE (strlen(RADIOON))
#define RADIOOFF       "\x1d\x23\x02\x23"
#define RADIOOFFSIZE (strlen(RADIOOFF))
#define FMTUNE      "\x1d\x23\x05\x23"
#define FMTUNESIZE (strlen(FMTUNE))
#define AMTUNE      "\x1d\x23\x09\x23"
#define AMTUNESIZE (strlen(AMTUNE))
#define RADIOENQ       "\x1d\x23\x08\x23"
#define RADIOENQSIZE (strlen(RADIOENQ))
#define RADIOACK       "\x1d\x23\x07\x23"
#define RADIOACKSIZE (strlen(RADIOACK))
#define RADIOACK2      "\x1d\x23\x04\x23"
#define FM      0
#define AM      1
#define OFF     0
#define ON      1
#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif
#define COMMAND  0
#define PIPELINE 1
#define STR_ACK "ACK"
#define STR_NAK "NAK"
#define STR_ENQ "ENQ"
#define STR_ON  "ON"
#define STR_OFF "OFF"
#define STR_AM  "AM"
#define STR_FM  "FM"
#define STR_VOL "VOL"

int openradio(char *);
void clearrts(int);
void setrts(int);
void cleardtr(int);
void setdtr(int);
int radioinit(char *);
void radioon(int);
void radiooff(int);
void radioclose(int);
void radiotune(int, char *, int);
int radioprobe(int);
int openmixer(int);
void setvolume(int, unsigned int);
int getvolume(int);
void closemixer(int);
void addrecsrc(int, int);
unsigned int hundred_times_strtoint(char *);
