/*

Kay, this is a blatent rip off of wminet, which is a very good example of how
to do a docklet.  I just modified it to "scratch my itch".


 wminet.c
 Inetd Monitor
 by Dave Clark (clarkd@skyia.com) and Antoine Nulle (warp@xs4all.nl)
 
 based on wmifs by Martijn Pieterse (pieterse@xs4all.nl).

 see http://windowmaker.mezaway.org for more awesome wm dock apps :)

*/


#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>

#include <sys/time.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include <utmp.h>
#include <dirent.h>

#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#include "../wmgeneral/wmgeneral.h"
#include "../wmgeneral/misc.h"

#include "wmcid-master.xpm"
#include "wmcid-mask.xbm"

struct cid{
	char Name[50];
	char Number[50];
	char Message[50];
	char Time[6];
	char Date[6];
};
#define CID_PORT	32100
#define WMCID_VERSION "0.0001 Alpha"
#define CHAR_WIDTH 5
#define CHAR_HEIGHT 7

extern	char **environ;

char	*ProgName;


void usage(void);
void printversion(void);
void BlitString(char *name, int x, int y);
void BlitNum(int num, int x, int y);
void wmcid_routine(int, char **);


void main(int argc, char *argv[]) {

	int		i;
	
	/* Parse Command Line */

	ProgName = argv[0];
	if (strlen(ProgName) >= 5)
		ProgName += (strlen(ProgName) - 5);
	
	for (i=1; i<argc; i++) {
		char *arg = argv[i];

		if (*arg=='-') {
			switch (arg[1]) {
			case 'd' :
				if (strcmp(arg+1, "display")) {
					usage();
					exit(1);
				}
				break;
			case 'v' :
				printversion();
				exit(0);
				break;
			default:
				usage();
				exit(0);
				break;
			}
		}
	}

	wmcid_routine(argc, argv);
}

/*******************************************************************************\
|* wminet_routine														   *|
\*******************************************************************************/

void wmcid_routine(int argc, char **argv)
{
	XEvent		Event;
	int s,len;
	struct cid cidinfo;
	struct sockaddr_in from,me;
	struct timeval tv;
	fd_set fin;
	char temp[11];

	openXwindow(argc, argv, wmcid_master_xpm, wmcid_mask_bits, wmcid_mask_width, wmcid_mask_height);


    // set up labels
    BlitString("  name   ", 5, 5);
    BlitString("  nmbr   ", 5, 16);
    BlitString("  mesg   ", 5, 27);
    BlitString("  time   ", 5, 38);
    BlitString("  date   ", 5, 49);

                
    
    RedrawWindow();

	if ((s = socket(AF_INET,SOCK_DGRAM,0))<0){
		fprintf(stderr,"Unable to create socket.\n");
		return;
	}
	
	me.sin_port = htons(CID_PORT);
	me.sin_addr.s_addr=INADDR_ANY;

	if (bind(s,(struct sockaddr *)&me,sizeof(struct sockaddr_in))<0){
		fprintf(stderr,"Unable to bind port [%d]\n",CID_PORT);
		return;
	}	    
    while (1)
    {
//		waitpid(0, NULL, WNOHANG);
        RedrawWindow();
		
		FD_ZERO(&fin);
		FD_SET(s,&fin);
		tv.tv_sec = 1;
		tv.tv_usec = 0;
		if (select(s+1,&fin,NULL,NULL,&tv)>0){
			if (FD_ISSET(s,&fin)){
				 recvfrom(s,&cidinfo, sizeof(struct cid),0,
				(struct sockaddr *)&from,&len);
				
				printf("Got CID packet.\n");
				printf("Name: [%s]\n",cidinfo.Name);
				printf("Number: [%s]\n",cidinfo.Number);
				printf("Message: [%s]\n",cidinfo.Message);
				printf("Time: [%s]\n",cidinfo.Time);
				printf("Date: [%s]\n",cidinfo.Date);
		
						

				snprintf(temp,10,"%-9s",cidinfo.Name);	
    			BlitString(temp, 5, 5);
					
    			snprintf(temp,10,"%-9s",cidinfo.Number);			
    			BlitString(temp, 5, 16);

				snprintf(temp,10,"%-9s",cidinfo.Message);	
    			BlitString(temp, 5, 27);

				snprintf(temp,10,"%-9s",cidinfo.Time);	
    			BlitString(temp, 5, 38);

				snprintf(temp,10,"%-9s",cidinfo.Date);	
			    BlitString(temp, 5, 49);
			    RedrawWindow();
			}
        }
        
        // X Events
        while (XPending(display))
        {
			XNextEvent(display, &Event);
            switch (Event.type)
            {
			case Expose:
				RedrawWindow();
				break;
			case DestroyNotify:
				XCloseDisplay(display);
				exit(0);
                break;
			}
		}
	}
}



// Blits a string at given co-ordinates
void BlitString(char *name, int x, int y)
{
    int		i;
	int		c;
    int		k;

	k = x;
    for (i=0; name[i]; i++)
    {

        c = toupper(name[i]);
        if (c=='/'){
        	c = 11;
        	copyXPMArea(c*6+2,64,6,8,k,y);
        	k+=6;
        } else if (isspace(c)){
        	c = 12;
        	copyXPMArea(c*6+1,64,6,8,k,y);
        	k+=6;
        } else if (c >= 'A' && c <= 'Z')
        {   // its a letter
			c -= 'A';
			copyXPMArea(c * 6, 74, 6, 8, k, y);
			k += 6;
        }
        else
        {   // its a number or symbol
			c -= '0';
			copyXPMArea(c * 6, 64, 6, 8, k, y);
			k += 6;
		}
	}

}


// Blits number to give coordinates.. two 0's, right justified

void BlitNum(int num, int x, int y)
{
    char buf[1024];
    int newx=x;

    if (num > 99)
    {
        newx -= CHAR_WIDTH;
    }

    if (num > 999)
    {
        newx -= CHAR_WIDTH;
    }

    sprintf(buf, "%02i", num);

    BlitString(buf, newx, y);
}
    




/*******************************************************************************\
|* usage																	   *|
\*******************************************************************************/

void usage(void)
{
    fprintf(stderr, "\nWMCID - PsyKotyk <psykotyk@psykotyk.dyn.ml.org>\n");
	fprintf(stderr, "usage:\n");
	fprintf(stderr, "\t-d <display name>\n");
	fprintf(stderr, "\t-h\tthis help screen\n");
	fprintf(stderr, "\t-v\tprint the version number\n");
	fprintf(stderr, "\n");
}

/*******************************************************************************\
|* printversion																   *|
\*******************************************************************************/

void printversion(void)
{
	fprintf(stderr, "wmcid v%s\n", WMCID_VERSION);
}
