#include "config.h"

Config::Config(char *Name)
{
	if ((In = fopen(Name,"rb"))==NULL)
		throw("Unable to open file.");
	Buffer = new char[255];
}

Config::~Config()
{
	fclose(In);
	delete Buffer;
}

char *Config::ScanKey(char *Key)
{
	char *eq;
	rewind(In);
	while(!feof(In)){
		fgets(Buffer,255,In);
		Clean();
		// Scan for the =
		eq = strchr(Buffer,'=');
		if (eq!=NULL){
			*eq = 0;
			if (strcmp(Buffer,Key)==0)
				return eq+1;
		}
	}
	return NULL;
}

void Config::Clean(void)
{
	char *p;
	p = strchr(Buffer,';');
	if (p)
		*p=0;
	p = strchr(Buffer,'\n');
	if (p)
		*p=0;
}

void Config::LoadKey(char *Key, char *Value, int Max)
{
	char *f,*a,*b;
	f = ScanKey(Key);
	if (f==NULL)
		throw("Key Not Found.");
	a = strchr(f,'"');
	if (a==NULL)
		throw("Key Not Text.");
	a++;
	b = strchr(a,'"');
	if (b==NULL)
		throw("No closing quote");
	f = Value;
	while ((a!=b) && ((f - Value) < Max))
		*f++=*a++;
	*f=0;
}

void Config::LoadKey(char *Key,long int &Num)
{
	char *a = ScanKey(Key);
	if (a==NULL)
		throw("Key Not Found");
	Num = strtol(a,NULL,0);
}

void Config::LoadKey(char *Key, int &Num)
{
	long int V;
	LoadKey(Key,V);
	Num = V;
}
