/*
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *
 *  This class wraps and extends Minicom.
 *  see ftp://ftp.sunsite.unc.edu/pub/Linux/apps/serialcomm/dialout
 */

#ifndef H_COM_H
#define H_COM_H
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include "sysdep.h"

void m_sethwf(int fd, int on);
void m_setrts(int fd);
void m_dtrtoggle(int fd,int sec);
void m_break(int fd);
int m_getdcd(int fd);
void m_setparms(int fd, char *baudr, char *par,char *bits,int hwf,int swf);
int m_getmaxspd(void);
int m_readchk(int fd);
void m_flush(int fd);



class Comm
{
public:
	Comm(void){}
	Comm(char *Device) { Open(Device); }
	void Open(char *Device){
		if ((com_fd = open(Device, O_RDWR | O_SYNC )) == -1 ) 
 			throw("Unable to open port.");
		flock( com_fd, LOCK_EX );
	}
	
	void Close(void) { close(com_fd); }
	~Comm(void) { Close(); }
	
	int GetFD(void) { return com_fd; }
	
	void SetParam(char *Baud, char *Parity, char *Bits,int HWFlow,int SWFlow){
		m_setparms(com_fd,Baud,Parity,Bits,HWFlow,SWFlow);
	}
	void SetHWFlow(int State){
		m_sethwf(com_fd,State);
	}
	
	void SetRTS(void){
		m_setrts(com_fd);
	}
	
	void ToggleDTR(int Delay){
		m_dtrtoggle(com_fd,Delay);
	}

	void SendBreak(void){
		m_break(com_fd);
	}

	void Flush(void){
		m_flush(com_fd);
	}

	int GetMaxBaud(void){
		return m_getmaxspd();
	}
	
	int CharReady(void){
		return m_readchk(com_fd);
	}
	
	int GetDCD(void){
		return m_getdcd(com_fd);
	}
	
	unsigned char comm_getc(void);
	void comm_putc(unsigned char B);
	int comm_gets(char *Buffer,int max);
	int comm_puts(char *Buffer);

	
	
protected:
	int com_fd;
	
};

#endif // H_COM_H