#include "cid.h"

CallID::CallID(void)
{
	// Here is where you would add routines to load data from a config file
	CID_TIME = "TIME = ";
	CID_DATE = "DATE = ";
	CID_MESG = "MESG = ";
	CID_NMBR = "NMBR = ";
	CID_NAME = "NAME = ";
	Message[0]=0;
	Number[0]=0;
	Name[0]=0;
}

int CallID::ParseLine(char *Line)
{
	if (CheckDATE(Line)){
		ParseDATE(Line);
		return 1;
	}
	if (CheckTIME(Line)){
		ParseTIME(Line);
		return 2;
	}
	if (CheckMESG(Line)){
		ParseMESG(Line);
		return 3;
	}
	if (CheckNMBR(Line)){
		ParseNMBR(Line);
		return 4;
	}
	if (CheckNAME(Line)){
		ParseNAME(Line);
		return 5;
	}
	return 0;
}

int CallID::CheckDATE(char *Line)
{
	return (strncmp(Line,CID_DATE,strlen(CID_DATE))==0);
}

int CallID::CheckTIME(char *Line)
{
	return (strncmp(Line,CID_TIME,strlen(CID_TIME))==0);
}

int CallID::CheckMESG(char *Line)
{
	return (strncmp(Line,CID_MESG,strlen(CID_MESG))==0);
}

int CallID::CheckNMBR(char *Line)
{
	return (strncmp(Line,CID_NMBR,strlen(CID_NMBR))==0);
}

int CallID::CheckNAME(char *Line)
{
	return (strncmp(Line,CID_NAME,strlen(CID_NAME))==0);
}


void CallID::ParseDATE(char *Line)
{
	int Month,Day;
	char Temp1[3],Temp2[3];
	struct tm *Temp3;
	
	// Copy out the Month & Date if it's long enough to have it.
	if (strlen(Line) < strlen(CID_DATE)+4)
		return;
	
	strncpy(Temp1,&Line[strlen(CID_DATE)],2);
	strncpy(Temp2,&Line[strlen(CID_DATE)+2],2);
	
	Month = atoi(Temp1);
	Day = atoi(Temp2);

	// Get the year from the computer	
	time_t i;
	if ((Temp3 = localtime(&(i=time(NULL))))!=NULL)
		tm_Time.tm_year = Temp3->tm_year;

	tm_Time.tm_mon = Month;
	tm_Time.tm_mday = Day;	
}

void CallID::ParseTIME(char *Line)
{
	int Hour,Min;
	char Temp1[3],Temp2[3];
	
	// Copy out the Month & Date if it's long enough to have it.
	if (strlen(Line) < strlen(CID_TIME)+4)
		return;
	
	strncpy(Temp1,&Line[strlen(CID_TIME)],2);
	strncpy(Temp2,&Line[strlen(CID_TIME)+2],2);
	
	Hour = atoi(Temp1);
	Min = atoi(Temp2);

	tm_Time.tm_hour = Hour;
	tm_Time.tm_min = Min;	
}

void CallID::ParseMESG(char *Line)
{
	strncpy(Message,&Line[strlen(CID_MESG)],80);
}

void CallID::ParseNMBR(char *Line)
{
	strncpy(Number,&Line[strlen(CID_NMBR)],50);
	if (Number[0]=='P')
		strcpy(Number,"Private Number");		
	if (Number[0]=='O')
		strcpy(Number,"Out of Area");
}

void CallID::ParseNAME(char *Line)
{
	strncpy(Name,&Line[strlen(CID_NAME)],50);
}

void CallID::ConvertMESG2NMBR(void)
{
	// For lame phone companies like mine who don't do NMBR, but
	// encode in the MESG
	int x,y=0;
	for(x=5;x<strlen(Message);x+=2)
		Number[y++] = Message[x];
	Number[y]=0;	
}		