
typedef unsigned long u_long;

#include "voice.h"
#include "cid.h"
#include "modem.h"
#include "com.h"
#include "config.h"

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <errno.h>
#include <signal.h>


#define HOST_LIST	"/etc/callid/cid_hosts"
#define MODEM_DEV	"/dev/modem"

static int StopDaemon = 0;

struct cid
{
	char Name[50];
	char Number[50];
	char Message[50];
	char Time[6];
	char Date[6];
};

void CID_SendUpdate(struct cid *c)
{
	int s,Port=32100;
	struct sockaddr_in broadcast;
	struct hostent *h;
	char *p,*Buffer = new char[255];
	FILE *list;
	 
	 if (Buffer==NULL){
	 	fprintf(stderr,"Unable to allocate buffer.\n");
	 	return;
	 }
	 
	if ((s = socket(AF_INET,SOCK_DGRAM,0))<0)
		fprintf(stderr,"Unable to create socket.\n");


	if ((list=fopen(HOST_LIST,"rt"))==NULL){
		fprintf(stderr,"Unable to open host list [%s]\n",HOST_LIST);
		return;
	}
	while(1){
		fgets(Buffer,255,list);
		if (feof(list)) break;
		if ((p=strchr(Buffer,'\n'))!=NULL) *p=0;
		if (Buffer[0]=='#' || Buffer[0]==0)
			continue;
			
		broadcast.sin_family = AF_INET;
		broadcast.sin_port = htons(Port);
		broadcast.sin_addr.s_addr = inet_addr(Buffer);
		if (broadcast.sin_addr.s_addr == INADDR_NONE){
			if ((h = gethostbyname(Buffer))==NULL){
				fprintf(stderr,"Unable to resolve host [%s] in [%s]\n",Buffer,HOST_LIST);
				continue;
			}
			broadcast.sin_addr.s_addr = *(long *)h->h_addr;
		}
	
		if (sendto(s,c,sizeof(struct cid),0,(struct sockaddr *)&broadcast,
				sizeof(struct sockaddr_in))!=sizeof(struct cid))
				fprintf(stderr,"Unable to send packet to [%s]\n",Buffer);
	}
	fclose(list);	
}
		
void sighandle( int sig ) {
	StopDaemon = 1;
}

int main(int argc, char **argv)
{
	Modem m;
	CallID c;
	char *Buffer,*p;
	Buffer = new char[255];
	struct cid cidinfo;

    signal(SIGTERM, sighandle);
	m.Open(MODEM_DEV);
	m.debug=0;
	sprintf(Buffer,"%ld",(long)m.GetMaxBaud()*100);
	m.SetParam(Buffer,"N","8",1,1);
	int x=m.SendAT("AT#CID=1");
	StopDaemon = 0;
	
	while(!StopDaemon){

		m.comm_gets(Buffer,255);
		if ((p=strchr(Buffer,'\r'))!=NULL) *p=0;
		x = c.ParseLine(Buffer);
		if (m.debug)
			printf("Return: %d\n",x);	
		if (x==3){
			c.ConvertMESG2NMBR();

			strcpy(cidinfo.Name,c.Name);
			strcpy(cidinfo.Number,c.Number);
			strcpy(cidinfo.Message,c.Message);
			sprintf(cidinfo.Time,"%02d:%02d",c.tm_Time.tm_hour,c.tm_Time.tm_min);
			sprintf(cidinfo.Date,"%02d/%02d",c.tm_Time.tm_mon,c.tm_Time.tm_mday);

			CID_SendUpdate(&cidinfo);
		}
	}
	printf("Closing Modem...");
	m.Close();
	delete Buffer;
}