/*
 * This code is in the public domain, but there are ABSOLUTELY NO
 * WARRANTIES OF ANY TYPE WHATSOEVER, WHEREVER YOU ARE, WHATEVER ARE
 * THE LAWS THERE AND WHATEVER HAPPENS TO YOU BY USING THIS CODE.
 */


#include <dockapp.h>
#include <unistd.h>

char *displayName = "";


static DAProgramOption options[] = {
    {"-display", NULL, "display to use", DOString, False, {&displayName} }
};


int
main(int argc, char **argv)
{
    Pixmap pixmap;
    GC gc;
    int i;

    DAParseArguments(argc, argv, options,
		     sizeof(options)/sizeof(DAProgramOption),
		     "test dockapp", "wmtest 1.0");

    DAInitialize(displayName, "WMTest", 48, 48, argc, argv);

    pixmap = DAMakePixmap();
    gc = DefaultGC(DADisplay, DefaultScreen(DADisplay));

    DAShow();

    i = 0;
    while (1) {
	XEvent ev;
	char buf[10];

	sprintf(buf, "%i", i);

	XSetForeground(DADisplay, gc, 
		       BlackPixel(DADisplay, DefaultScreen(DADisplay)));
	XFillRectangle(DADisplay, pixmap, gc, 0, 0, 48, 48);

	XSetForeground(DADisplay, gc, 
		       WhitePixel(DADisplay, DefaultScreen(DADisplay)));
	XDrawString(DADisplay, pixmap, gc, 5, 24, buf, strlen(buf));

	DASetPixmap(pixmap);

	/* handle all pending X events */
	while (XPending(DADisplay)) {
	    XNextEvent(DADisplay, &ev);
	    DAProcessEvent(&ev);
	}

	sleep(1);
	i++;
    }

    return 0;
}

