#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <stdlib.h>
#include <signal.h>
#include <stdio.h>

#include "pixmaps/koi.xpm"
#include "pixmaps/cp1251.xpm"
#include "pixmaps/iso8859_5.xpm"
#include "pixmaps/mask.xpm"
#include "pixmaps/en.xpm"
#include "pixmaps/ru.xpm"

#include "cyrmapper.h"

CyrEncoding iso_encoding[]={
#include "iso8859.h"
};

CyrEncoding koi_encoding[]={
#include "koi8.h"
};

CyrEncoding msw_encoding[]={
#include "msw.h"
};

CyrLayout cyrlayout[]={
#include "cyrl.h"
};

AuxLayout auxlayout[]={
  {XK_slash, XK_question, XK_period, XK_comma},
  {XK_1, XK_exclam, XK_1, XK_exclam}
};


CyrMapper KOI("koi8", 
	      cyrlayout, 
	      auxlayout, 
	      (sizeof(auxlayout)/(4*sizeof(KeySym))),
	      koi_encoding);
	      
CyrMapper ISO("iso 8859-5", 
	      cyrlayout, 
	      auxlayout, 
	      (sizeof(auxlayout)/(4*sizeof(KeySym))),
	      iso_encoding);


CyrMapper MSW("MS Windows", 
	      cyrlayout, 
	      auxlayout, 
	      (sizeof(auxlayout)/(4*sizeof(KeySym))),
	      msw_encoding);

inline min(int a, int b) { return (a<b) ? a : b; }

int CYRSIZE=min(sizeof(iso_encoding)/(sizeof(CyrSym) + 2*sizeof(CyrCode)),
		sizeof(cyrlayout)/(2*sizeof(KeySym) + sizeof(CyrSym)));

CyrMapper *current_mapping=&MSW; 

void SigHandler(int);

/* X11 Variablen *************************************************************/
Display *dpy;	  /* welches DISPLAY */
Window Root;      /* Hintergrund-Drawable */
int screen;
int x_fd;
int d_depth;
XSizeHints mysizehints;
XWMHints mywmhints;
Pixel back_pix, fore_pix;
GC NormalGC;
Window iconwin, win;       /* My home is my window */
char *ProgName;
char *Geometry;
char *LedColor = "LightSeaGreen";
/* XPM Variablen *************************************************************/
struct XpmIcon {
  Pixmap pixmap;
  Pixmap mask;
  XpmAttributes attributes;
  void load(char**);
  void draw(int x, int y);
};

XpmIcon koi, cp1251, iso8859_5, mask, en, ru;

XpmIcon* currentEncoding=&cp1251;
XpmIcon* currentLang=&en;
XpmIcon* oldLang=&en;

/* lokale Funktionen *********************************************************/
#define MW_EVENTS   (ExposureMask | ButtonPressMask | StructureNotifyMask | KeyPressMask | PropertyChangeMask)
void RedrawWindow();
Pixel GetColor(char *name);
void ExitGracefully();

int main(int argc,char *argv[])
{
  int i;
  unsigned int borderwidth ;
  char *display_name = NULL; 
  char *wname = "cyrx";
  XGCValues gcv;
  unsigned long gcm;
  XEvent event;
  XTextProperty name;
  XClassHint classHint;
  Pixmap pixmask;
  ProgName = argv[0];
  Geometry = "";
  
  /* Parse command line options */
  ProgName = argv[0];
  for(i=1;i<argc;i++) {
    char *arg= argv[i];

    if (arg[0] == '-') {
      switch(arg[1]) {
      case 'w':
	currentEncoding=&cp1251;
	break;
      case 'k':
	currentEncoding=&koi;
	break;	
      case 'i':
	currentEncoding=&iso8859_5;
        break;
      default:
	fprintf(stderr,"usage:  %s [-win | -koi | -iso] \n", ProgName);
	exit(1);
      }
    }
  }

  /* Open the display */
  if (!(dpy = XOpenDisplay(display_name)))  
    { 
      fprintf(stderr,"cyrx: can't open display %s\n", 
	      XDisplayName(display_name)); 
      exit (1); 
    } 
  screen= DefaultScreen(dpy);
  Root = RootWindow(dpy, screen);
  d_depth = DefaultDepth(dpy, screen);
  x_fd = XConnectionNumber(dpy);
  
  /* Icon Daten nach XImage konvertieren */
  koi.load(koi_xpm);
  cp1251.load(cp1251_xpm);
  iso8859_5.load(iso8859_5_xpm);
  mask.load(mask_xpm);
  en.load(en_xpm);
  ru.load(ru_xpm);
  
  /* Create a window to hold the banner */
  mysizehints.flags= USSize|USPosition;
  mysizehints.x = 0;
  mysizehints.y = 0;

  back_pix = GetColor("white");
  fore_pix = GetColor("black");

  XWMGeometry(dpy, screen, Geometry, NULL, (borderwidth =1), &mysizehints,
	      &mysizehints.x,&mysizehints.y,&mysizehints.width,&mysizehints.height, &i); 

  mysizehints.width = mask.attributes.width;
  mysizehints.height= mask.attributes.height;

  win = XCreateSimpleWindow(dpy,Root,mysizehints.x,mysizehints.y,
			    mysizehints.width,mysizehints.height,
			    borderwidth,fore_pix,back_pix);
  iconwin = XCreateSimpleWindow(dpy,win,mysizehints.x,mysizehints.y,
				mysizehints.width,mysizehints.height,
				borderwidth,fore_pix,back_pix);

  /* Hints aktivieren */
  XSetWMNormalHints(dpy, win, &mysizehints);
  classHint.res_name =  "cyrx";
  classHint.res_class = "CyrX";
  XSetClassHint(dpy, win, &classHint);

  Atom _XA_WM_PROTOCOLS = XInternAtom(dpy, "WM_PROTOCOLS", False);
  Atom _XA_WM_DELETE_WINDOW = XInternAtom(dpy, "WM_DELETE_WINDOW", False);
  XSetWMProtocols(dpy, win,&_XA_WM_DELETE_WINDOW, 1);
  //XSetWMProtocols(dpy, iconwin,&_XA_WM_DELETE_WINDOW, 1);

  XSelectInput(dpy,win,MW_EVENTS);
  XSelectInput(dpy,iconwin,MW_EVENTS);
  
  if (XStringListToTextProperty(&wname, 1, &name) ==0) {
    fprintf(stderr, "cyrx: can't allocate window name\n");
    exit(-1);
  }
  XSetWMName(dpy, win, &name);
  
  /* Create a GC for drawing */
  gcm = GCForeground|GCBackground|GCGraphicsExposures;
  gcv.foreground = fore_pix;
  gcv.background = back_pix;
  gcv.graphics_exposures = 0;
  NormalGC = XCreateGC(dpy, Root, gcm, &gcv);  

  if (1) { /* try to make shaped window here */
    XShapeCombineMask(dpy, win, ShapeBounding, 0, 0, 
		      mask.mask, ShapeSet);
    XShapeCombineMask(dpy, iconwin, ShapeBounding, 0, 0, 
		      mask.mask, ShapeSet);
  }  

  //mywmhints.initial_state = NormalState;
  mywmhints.initial_state = WithdrawnState;
  mywmhints.icon_window = iconwin;
  mywmhints.icon_x = mysizehints.x;
  mywmhints.icon_y = mysizehints.y;
  mywmhints.window_group = win;
  mywmhints.flags = StateHint | IconWindowHint | IconPositionHint 
      | WindowGroupHint;
  XSetWMHints(dpy, win, &mywmhints); 

  XSetCommand(dpy, win, argv, argc);
  XMapWindow(dpy,win);
  RedrawWindow();

  XGrabKey(dpy, XKeysymToKeycode(dpy, XK_Shift_R),ShiftMask, Root, False,
	   GrabModeAsync, GrabModeAsync);
  XGrabKey(dpy, XKeysymToKeycode(dpy, XK_Shift_L),ShiftMask, Root, False,
	   GrabModeAsync, GrabModeAsync);
  int rshift=XKeysymToKeycode(dpy, XK_Shift_R);
  int lshift=XKeysymToKeycode(dpy, XK_Shift_L);
  /*
    Catch some signals so we can restore original keyboard mapping.
    */
  //signal(SIGKILL, SigHandler); :)))))
  signal(SIGINT, SigHandler);
  signal(SIGTERM, SigHandler);
  signal(SIGHUP, SigHandler);

  if (currentEncoding==&cp1251) {
    current_mapping=&MSW;
  } else if (currentEncoding==&koi) {
    current_mapping=&KOI;
  } else {
    current_mapping=&ISO;
  }

  while (1) {
      XNextEvent(dpy,&event);
//       fprintf(stderr, "got event\n");
//       fflush(stderr);
      switch(event.type)
	{
	case ClientMessage:
	  //fprintf(stderr, "got ClientMessage\n");
	  if ( event.xclient.message_type == _XA_WM_PROTOCOLS
	      && event.xclient.data.l[0] == _XA_WM_DELETE_WINDOW) {
	    //fprintf(stderr, "got _XA_WM_DELETE_WINDOW\n");
	    SigHandler(0);
	  }
	  //fflush(stderr);
	  break;
	case DestroyNotify:
	  //fprintf(stderr, "got DestroyNotify\n");
	  //fflush(stderr);
	  SigHandler(0);
	  break;      
	case Expose:
	  if(event.xexpose.count == 0 )
	    RedrawWindow();
	  break;
	case KeyPress:
	  if(event.xkey.state==ShiftMask &&(event.xkey.keycode==rshift || event.xkey.keycode==lshift)) {
	    if (currentLang==&en) {
	      currentLang=&ru;
	      current_mapping->set_cyr();
	    } else {
	      currentLang=&en;
	      current_mapping->restore_lat();
	    }
	  }
	  RedrawWindow();
	  break;
	case ButtonPress:
	  if (currentLang==&ru) {	  
	    current_mapping->restore_lat();
	  }
	  if (currentEncoding==&cp1251) {
	    currentEncoding=&koi;
	    current_mapping=&KOI;
	  } else if (currentEncoding==&koi) {
	    currentEncoding=&iso8859_5;
	    current_mapping=&ISO;
	  } else {
	    currentEncoding=&cp1251;
	    current_mapping=&MSW;
	  }
	  if (currentLang==&ru) {	  
	    current_mapping->set_cyr();
	  }
	  RedrawWindow();
	  break;
	default:
	  break;      
	}
    XFlush(dpy);
  }
  return 0;
}
/****************************************************************************/
void SigHandler(int sig)
{
  if (sig!=0) {
    fprintf(stderr, "CyrX: killed with signal %d\n", sig);
  }
  if (currentLang==&ru) {
    current_mapping->restore_lat();
    if (sig!=0) {
      fprintf(stderr, "CyrX: Restoring Latin layout");
    }
  }
  XCloseDisplay(dpy);
  exit(0); 
}

/****************************************************************************/
/* Konvertiere XPMIcons nach XImage */
void XpmIcon::load(char** xxx)
{
  attributes.valuemask |= (XpmReturnPixels | XpmReturnExtensions);
  int ret = XpmCreatePixmapFromData(dpy, Root, xxx, &pixmap, 
				&mask, &attributes);
  if(ret != XpmSuccess)
    {fprintf(stderr, "not enough free color cells\n");exit(1);}
}

void XpmIcon::draw(int x, int y)
{
  XCopyArea(dpy, pixmap, ::mask.pixmap, NormalGC,
	    0,0,attributes.width,attributes.height,x,y);
}

/****************************************************************************/
/* Removes expose events for a specific window from the queue */
int flush_expose (Window w)
{
  XEvent dummy;
  int i=0;
  
  while (XCheckTypedWindowEvent (dpy, w, Expose, &dummy))i++;
  return i;
}

/****************************************************************************/
void RedrawWindow()
{
  currentEncoding->draw(2, 2);
  currentLang->draw(29,2);
  
  flush_expose (iconwin);
  XCopyArea(dpy,mask.pixmap,iconwin,NormalGC,0,0,
	    mask.attributes.width, 
	    mask.attributes.height,0,0);
  flush_expose (win);
  XCopyArea(dpy,mask.pixmap,win,NormalGC,0,0,
	    mask.attributes.width, 
	    mask.attributes.height,0,0);
  oldLang=currentLang;
}
/****************************************************************************/
void nocolor(char *a, char *b)
{
 fprintf(stderr,"cyrx: can't %s %s\n", a,b);
}
/****************************************************************************/
Pixel GetColor(char *name)
{
  XColor color;
  XWindowAttributes attributes;

  XGetWindowAttributes(dpy,Root,&attributes);
  color.pixel = 0;
   if (!XParseColor (dpy, attributes.colormap, name, &color)) 
     {
       nocolor("parse",name);
     }
   else if(!XAllocColor (dpy, attributes.colormap, &color)) 
     {
       nocolor("alloc",name);
     }
  return color.pixel;
}
