// This code may look like C, but this is really -*- C++ -*-

#include <X11/Xlib.h>
#include <X11/keysym.h>

extern int screen;
extern Display	*dpy;

typedef enum CyrSym {
#include "cyrsym.h"
  } ;

extern int  CYRSIZE;          // number of characters in cyrillic alphabet

typedef KeySym CyrCode;


struct CyrLayout {
  KeySym keysym1;        // unshifted
  KeySym keysym2;        // shifted
  CyrSym cyrsym;
};

struct AuxLayout {
  KeySym keysym1;
  KeySym keysym2;
  KeySym new_keysym1;
  KeySym new_keysym2;
};

struct CyrEncoding {
  CyrSym cyrsym;
  CyrCode cyrcode;
  CyrCode cap_cyrcode;
};
  



class CyrMapper {
  static KeySym *orig_maptab;
  static int N_of_instances;
  static int keysyms_per_keycode;

  char *name;
  int id;

  CyrLayout *layout;

  const AuxLayout* auxlayout;
  int auxl_size;

  CyrEncoding *encoding;

  CyrCode *cyr_maptab;

  CyrCode CyrsymToCyrcode(CyrSym);
  CyrCode CyrsymToCapCyrcode(CyrSym);
  int CyrsymToPlace(CyrSym);

  int max_cyrkey;
  int min_cyrkey;

  void X_specific_init();
public:
  CyrMapper(char *codeset_name, 
	    CyrLayout*, 
	    AuxLayout*, 
	    int auxl_sz,
	    CyrEncoding*);
  operator int (void) { return id; }
  operator char *(void) { X_specific_init(); return name; }
  void set_cyr();
  void restore_lat();
  ~CyrMapper();
};



