h07238
s 00028/00037/00369
d D 1.10 98/07/04 19:01:30 mini 10 9
c new design - the first real good one
c 
e
s 00001/00001/00405
d D 1.9 98/07/04 18:23:58 mini 9 8
c 
e
s 00000/00000/00406
d D 1.8 98/03/14 22:42:54 mini 8 7
c 
e
s 00038/00025/00368
d D 1.7 98/03/14 22:18:44 mini 7 6
c 
e
s 00034/00014/00359
d D 1.6 98/03/14 21:42:16 mini 6 5
c 
e
s 00005/00003/00368
d D 1.5 98/03/07 22:46:03 mini 5 4
c 
e
s 00034/00002/00337
d D 1.4 98/03/07 22:08:21 mini 4 3
c 
e
s 00082/00006/00257
d D 1.3 98/03/07 21:36:10 mini 3 2
c 
e
s 00042/00018/00221
d D 1.2 98/03/07 20:49:59 mini 2 1
c 
e
s 00239/00000/00000
d D 1.1 98/03/07 20:23:46 mini 1 0
c 
e
u
U
f b 
f e 0
t
T
I 1
D 3
#include <stdio.h>
E 3
#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>
D 3
#include <time.h>
E 3
#include <X11/Xatom.h>
D 3
#include <stdlib.h>
E 3
I 2
#include <X11/keysym.h>
I 3
#include <stdlib.h>
#include <signal.h>
#include <stdio.h>
D 6
#include <iostream.h>
E 6
E 3
E 2

D 7
#include "pixmaps/rus.xpm"
#include "pixmaps/lat.xpm"
E 7
I 7
D 10
//#include "pixmaps/rus.xpm"
//#include "pixmaps/lat.xpm"
E 10
E 7
#include "pixmaps/koi.xpm"
#include "pixmaps/cp1251.xpm"
I 4
#include "pixmaps/iso8859_5.xpm"
E 4
D 7
#include "pixmaps/mask.xpm"
E 7
I 7
D 10
#include "pixmaps/mask_en.xpm"
#include "pixmaps/mask_ru.xpm"
E 10
I 10
#include "pixmaps/mask.xpm"
#include "pixmaps/en.xpm"
#include "pixmaps/ru.xpm"
E 10
E 7

I 3
#include "cyrmapper.h"

CyrEncoding iso_encoding[]={
#include "iso8859.h"
};

CyrEncoding koi_encoding[]={
#include "koi8.h"
};

CyrEncoding msw_encoding[]={
#include "msw.h"
};

CyrLayout cyrlayout[]={
#include "cyrl.h"
};

AuxLayout auxlayout[]={
  {XK_slash, XK_question, XK_period, XK_comma},
  {XK_1, XK_exclam, XK_1, XK_exclam}
};


CyrMapper KOI("koi8", 
	      cyrlayout, 
	      auxlayout, 
	      (sizeof(auxlayout)/(4*sizeof(KeySym))),
	      koi_encoding);
	      
D 4
CyrMapper ISO("iso 8859", 
E 4
I 4
CyrMapper ISO("iso 8859-5", 
E 4
	      cyrlayout, 
	      auxlayout, 
	      (sizeof(auxlayout)/(4*sizeof(KeySym))),
	      iso_encoding);


CyrMapper MSW("MS Windows", 
	      cyrlayout, 
	      auxlayout, 
	      (sizeof(auxlayout)/(4*sizeof(KeySym))),
	      msw_encoding);

inline min(int a, int b) { return (a<b) ? a : b; }

int CYRSIZE=min(sizeof(iso_encoding)/(sizeof(CyrSym) + 2*sizeof(CyrCode)),
		sizeof(cyrlayout)/(2*sizeof(KeySym) + sizeof(CyrSym)));

CyrMapper *current_mapping=&MSW; 

void SigHandler(int);

E 3
/* X11 Variablen *************************************************************/
Display *dpy;	  /* welches DISPLAY */
Window Root;      /* Hintergrund-Drawable */
int screen;
int x_fd;
int d_depth;
XSizeHints mysizehints;
XWMHints mywmhints;
Pixel back_pix, fore_pix;
GC NormalGC;
Window iconwin, win;       /* My home is my window */
char *ProgName;
char *Geometry;
char *LedColor = "LightSeaGreen";
/* XPM Variablen *************************************************************/
struct XpmIcon {
  Pixmap pixmap;
  Pixmap mask;
  XpmAttributes attributes;
  void load(char**);
  void draw(int x, int y);
};

D 4
XpmIcon koi, cp1251, rus, lat, mask;
E 4
I 4
D 7
XpmIcon koi, cp1251, iso8859_5, rus, lat, mask;
E 7
I 7
D 10
XpmIcon koi, cp1251, iso8859_5, mask_en, mask_ru;
E 10
I 10
XpmIcon koi, cp1251, iso8859_5, mask, en, ru;
E 10
E 7
E 4

I 2
XpmIcon* currentEncoding=&cp1251;
D 7
XpmIcon* currentLang=&lat;
E 7
I 7
D 10
XpmIcon* currentLang=&mask_en;
XpmIcon* oldLang=&mask_en;
E 10
I 10
XpmIcon* currentLang=&en;
XpmIcon* oldLang=&en;
E 10
E 7

E 2
/* lokale Funktionen *********************************************************/
D 2
#define MW_EVENTS   (ExposureMask | ButtonPressMask | StructureNotifyMask)
E 2
I 2
D 6
#define MW_EVENTS   (ExposureMask | ButtonPressMask | StructureNotifyMask | KeyPressMask)
E 6
I 6
#define MW_EVENTS   (ExposureMask | ButtonPressMask | StructureNotifyMask | KeyPressMask | PropertyChangeMask)
E 6
E 2
void RedrawWindow();
Pixel GetColor(char *name);
I 2
void ExitGracefully();
E 2

int main(int argc,char *argv[])
{
  int i;
  unsigned int borderwidth ;
  char *display_name = NULL; 
  char *wname = "cyrx";
  XGCValues gcv;
  unsigned long gcm;
D 2
  XEvent Event;
E 2
I 2
  XEvent event;
E 2
  XTextProperty name;
  XClassHint classHint;
  Pixmap pixmask;
  ProgName = argv[0];
  Geometry = "";
  
  /* Parse command line options */
  ProgName = argv[0];
I 4
  for(i=1;i<argc;i++) {
    char *arg= argv[i];
E 4

I 4
    if (arg[0] == '-') {
      switch(arg[1]) {
      case 'w':
	currentEncoding=&cp1251;
	break;
      case 'k':
	currentEncoding=&koi;
	break;	
      case 'i':
	currentEncoding=&iso8859_5;
        break;
      default:
	fprintf(stderr,"usage:  %s [-win | -koi | -iso] \n", ProgName);
	exit(1);
      }
    }
  }

E 4
  /* Open the display */
  if (!(dpy = XOpenDisplay(display_name)))  
    { 
      fprintf(stderr,"cyrx: can't open display %s\n", 
	      XDisplayName(display_name)); 
      exit (1); 
    } 
  screen= DefaultScreen(dpy);
  Root = RootWindow(dpy, screen);
  d_depth = DefaultDepth(dpy, screen);
  x_fd = XConnectionNumber(dpy);
  
  /* Icon Daten nach XImage konvertieren */
  koi.load(koi_xpm);
  cp1251.load(cp1251_xpm);
I 4
  iso8859_5.load(iso8859_5_xpm);
E 4
D 7
  rus.load(rus_xpm);
  lat.load(lat_xpm);
  mask.load(mask_xpm);
E 7
I 7
D 10
  mask_en.load(mask_en_xpm);
  mask_ru.load(mask_ru_xpm);
E 10
I 10
  mask.load(mask_xpm);
  en.load(en_xpm);
  ru.load(ru_xpm);
E 10
E 7
  
  /* Create a window to hold the banner */
  mysizehints.flags= USSize|USPosition;
  mysizehints.x = 0;
  mysizehints.y = 0;

  back_pix = GetColor("white");
  fore_pix = GetColor("black");

  XWMGeometry(dpy, screen, Geometry, NULL, (borderwidth =1), &mysizehints,
	      &mysizehints.x,&mysizehints.y,&mysizehints.width,&mysizehints.height, &i); 

D 7
  mysizehints.width = mask.attributes.width;
  mysizehints.height= mask.attributes.height;
E 7
I 7
D 10
  mysizehints.width = currentLang->attributes.width;
  mysizehints.height= currentLang->attributes.height;
E 10
I 10
  mysizehints.width = mask.attributes.width;
  mysizehints.height= mask.attributes.height;
E 10
E 7

  win = XCreateSimpleWindow(dpy,Root,mysizehints.x,mysizehints.y,
			    mysizehints.width,mysizehints.height,
			    borderwidth,fore_pix,back_pix);
  iconwin = XCreateSimpleWindow(dpy,win,mysizehints.x,mysizehints.y,
				mysizehints.width,mysizehints.height,
				borderwidth,fore_pix,back_pix);

  /* Hints aktivieren */
  XSetWMNormalHints(dpy, win, &mysizehints);
  classHint.res_name =  "cyrx";
  classHint.res_class = "CyrX";
  XSetClassHint(dpy, win, &classHint);

I 6
  Atom _XA_WM_PROTOCOLS = XInternAtom(dpy, "WM_PROTOCOLS", False);
  Atom _XA_WM_DELETE_WINDOW = XInternAtom(dpy, "WM_DELETE_WINDOW", False);
  XSetWMProtocols(dpy, win,&_XA_WM_DELETE_WINDOW, 1);
  //XSetWMProtocols(dpy, iconwin,&_XA_WM_DELETE_WINDOW, 1);

E 6
  XSelectInput(dpy,win,MW_EVENTS);
  XSelectInput(dpy,iconwin,MW_EVENTS);
  
  if (XStringListToTextProperty(&wname, 1, &name) ==0) {
    fprintf(stderr, "cyrx: can't allocate window name\n");
    exit(-1);
  }
  XSetWMName(dpy, win, &name);
  
  /* Create a GC for drawing */
  gcm = GCForeground|GCBackground|GCGraphicsExposures;
  gcv.foreground = fore_pix;
  gcv.background = back_pix;
  gcv.graphics_exposures = 0;
  NormalGC = XCreateGC(dpy, Root, gcm, &gcv);  

  if (1) { /* try to make shaped window here */
D 7
    XShapeCombineMask(dpy, win, ShapeBounding, 0, 0, mask.mask, ShapeSet);
    XShapeCombineMask(dpy, iconwin, ShapeBounding, 0, 0, mask.mask, ShapeSet);
E 7
I 7
    XShapeCombineMask(dpy, win, ShapeBounding, 0, 0, 
D 10
		      currentLang->mask, ShapeSet);
E 10
I 10
		      mask.mask, ShapeSet);
E 10
    XShapeCombineMask(dpy, iconwin, ShapeBounding, 0, 0, 
D 10
		      currentLang->mask, ShapeSet);
E 10
I 10
		      mask.mask, ShapeSet);
E 10
E 7
D 6
  }
  
E 6
I 6
  }  

  //mywmhints.initial_state = NormalState;
E 6
  mywmhints.initial_state = WithdrawnState;
  mywmhints.icon_window = iconwin;
  mywmhints.icon_x = mysizehints.x;
  mywmhints.icon_y = mysizehints.y;
  mywmhints.window_group = win;
  mywmhints.flags = StateHint | IconWindowHint | IconPositionHint 
      | WindowGroupHint;
  XSetWMHints(dpy, win, &mywmhints); 

  XSetCommand(dpy, win, argv, argc);
  XMapWindow(dpy,win);
I 3
  RedrawWindow();
E 3

I 2
  XGrabKey(dpy, XKeysymToKeycode(dpy, XK_Shift_R),ShiftMask, Root, False,
	   GrabModeAsync, GrabModeAsync);
  XGrabKey(dpy, XKeysymToKeycode(dpy, XK_Shift_L),ShiftMask, Root, False,
	   GrabModeAsync, GrabModeAsync);
  int rshift=XKeysymToKeycode(dpy, XK_Shift_R);
  int lshift=XKeysymToKeycode(dpy, XK_Shift_L);
I 3
  /*
    Catch some signals so we can restore original keyboard mapping.
    */
D 6
  signal(SIGKILL, SigHandler);
E 6
I 6
  //signal(SIGKILL, SigHandler); :)))))
E 6
  signal(SIGINT, SigHandler);
  signal(SIGTERM, SigHandler);
  signal(SIGHUP, SigHandler);
E 3

I 4
  if (currentEncoding==&cp1251) {
    current_mapping=&MSW;
  } else if (currentEncoding==&koi) {
    current_mapping=&KOI;
  } else {
    current_mapping=&ISO;
  }
E 4
E 2
D 3
  RedrawWindow();
E 3
I 3

E 3
D 6
  /* read a packet */
  while (1)
    {
E 6
I 6
  while (1) {
E 6
D 2
      XNextEvent(dpy,&Event);
      switch(Event.type)
E 2
I 2
      XNextEvent(dpy,&event);
I 6
//       fprintf(stderr, "got event\n");
//       fflush(stderr);
E 6
      switch(event.type)
E 2
	{
I 6
	case ClientMessage:
	  //fprintf(stderr, "got ClientMessage\n");
	  if ( event.xclient.message_type == _XA_WM_PROTOCOLS
	      && event.xclient.data.l[0] == _XA_WM_DELETE_WINDOW) {
	    //fprintf(stderr, "got _XA_WM_DELETE_WINDOW\n");
	    SigHandler(0);
	  }
	  //fflush(stderr);
	  break;
	case DestroyNotify:
	  //fprintf(stderr, "got DestroyNotify\n");
	  //fflush(stderr);
	  SigHandler(0);
	  break;      
E 6
	case Expose:
D 2
	  if(Event.xexpose.count == 0 )
E 2
I 2
	  if(event.xexpose.count == 0 )
E 2
	    RedrawWindow();
	  break;
I 2
	case KeyPress:
D 9
	  if(event.xkey.keycode==rshift || event.xkey.keycode==lshift) {
E 9
I 9
	  if(event.xkey.state==ShiftMask &&(event.xkey.keycode==rshift || event.xkey.keycode==lshift)) {
E 9
D 7
	    if (currentLang==&lat) {
	      currentLang=&rus;
E 7
I 7
D 10
	    if (currentLang==&mask_en) {
	      currentLang=&mask_ru;
E 10
I 10
	    if (currentLang==&en) {
	      currentLang=&ru;
E 10
E 7
I 3
	      current_mapping->set_cyr();
E 3
	    } else {
D 7
	      currentLang=&lat;
E 7
I 7
D 10
	      currentLang=&mask_en;
E 10
I 10
	      currentLang=&en;
E 10
E 7
I 3
	      current_mapping->restore_lat();
E 3
	    }
	  }
	  RedrawWindow();
	  break;
E 2
	case ButtonPress:
I 3
D 7
	  if (currentLang==&rus) {	  
E 7
I 7
D 10
	  if (currentLang==&mask_ru) {	  
E 10
I 10
	  if (currentLang==&ru) {	  
E 10
E 7
	    current_mapping->restore_lat();
	  }
E 3
D 2
	  /*system(Execute);*/
E 2
I 2
	  if (currentEncoding==&cp1251) {
	    currentEncoding=&koi;
I 3
	    current_mapping=&KOI;
I 4
	  } else if (currentEncoding==&koi) {
	    currentEncoding=&iso8859_5;
	    current_mapping=&ISO;
E 4
E 3
	  } else {
	    currentEncoding=&cp1251;
I 3
	    current_mapping=&MSW;
E 3
	  }
I 3
D 7
	  if (currentLang==&rus) {	  
E 7
I 7
D 10
	  if (currentLang==&mask_ru) {	  
E 10
I 10
	  if (currentLang==&ru) {	  
E 10
E 7
	    current_mapping->set_cyr();
	  }
E 3
	  RedrawWindow();
E 2
	  break;
D 6
	case DestroyNotify:
D 2
	  /*
	   * Don't need these as XCloseDisplay() will
	   * free them. 
	   XFreeGC(dpy, NormalGC);
	   XDestroyWindow(dpy, win);
	   XDestroyWindow(dpy, iconwin);
	   */
	  XCloseDisplay(dpy);
	  exit(0); 
E 2
I 2
D 3
	  ExitGracefully();
E 3
I 3
	  SigHandler(0);
E 6
E 3
E 2
	default:
	  break;      
	}
D 6
      XFlush(dpy);
    }
E 6
I 6
    XFlush(dpy);
  }
E 6
  return 0;
}
D 2

E 2
/****************************************************************************/
I 2
D 3
void ExitGracefully()
E 3
I 3
void SigHandler(int sig)
E 3
{
I 6
  if (sig!=0) {
    fprintf(stderr, "CyrX: killed with signal %d\n", sig);
  }
E 6
I 3
D 5
  current_mapping->restore_lat();
  if (sig!=0) {
    fprintf(stderr, "CyrX: Restoring Latin layout and exiting -- killed with signal %d\n", sig);
E 5
I 5
D 7
  if (currentLang==&rus) {
E 7
I 7
D 10
  if (currentLang==&mask_ru) {
E 10
I 10
  if (currentLang==&ru) {
E 10
E 7
    current_mapping->restore_lat();
    if (sig!=0) {
D 6
      fprintf(stderr, "CyrX: Restoring Latin layout and exiting -- killed with signal %d\n", sig);
E 6
I 6
      fprintf(stderr, "CyrX: Restoring Latin layout");
E 6
    }
E 5
  }
E 3
  XCloseDisplay(dpy);
  exit(0); 
}
I 3

E 3
/****************************************************************************/
E 2
/* Konvertiere XPMIcons nach XImage */
void XpmIcon::load(char** xxx)
{
  attributes.valuemask |= (XpmReturnPixels | XpmReturnExtensions);
  int ret = XpmCreatePixmapFromData(dpy, Root, xxx, &pixmap, 
				&mask, &attributes);
  if(ret != XpmSuccess)
    {fprintf(stderr, "not enough free color cells\n");exit(1);}
}

void XpmIcon::draw(int x, int y)
{
D 7
  XCopyArea(dpy, pixmap, ::mask.pixmap, NormalGC,
E 7
I 7
D 10
  XCopyArea(dpy, pixmap, currentLang->pixmap, NormalGC,
E 10
I 10
  XCopyArea(dpy, pixmap, ::mask.pixmap, NormalGC,
E 10
E 7
	    0,0,attributes.width,attributes.height,x,y);
}

/****************************************************************************/
/* Removes expose events for a specific window from the queue */
int flush_expose (Window w)
{
  XEvent dummy;
  int i=0;
  
  while (XCheckTypedWindowEvent (dpy, w, Expose, &dummy))i++;
  return i;
}

/****************************************************************************/
D 10
/* Draws the icon window */
E 10
void RedrawWindow()
{
D 2
  cp1251.draw(6, 4);
  lat.draw(11,26);
E 2
I 2
D 10
  currentEncoding->draw(6, 4);
D 6
  currentLang->draw(11,26);
E 6
I 6
D 7
  currentLang->draw(16,26);
E 7
I 7
  //currentLang->draw(16,26);
E 10
I 10
  currentEncoding->draw(2, 2);
  currentLang->draw(29,2);
E 10
E 7
E 6
E 2
  
  flush_expose (iconwin);
D 7
  XCopyArea(dpy,mask.pixmap,iconwin,NormalGC,
	    0,0,mask.attributes.width, mask.attributes.height,0,0);
E 7
I 7
D 10
  if (oldLang!=currentLang) {
    XShapeCombineMask(dpy, iconwin, ShapeBounding, 0, 0, 
		      currentLang->mask, ShapeSet);
  }
  XCopyArea(dpy,currentLang->pixmap,iconwin,NormalGC,0,0,
	    currentLang->attributes.width, 
	    currentLang->attributes.height,0,0);
E 10
I 10
  XCopyArea(dpy,mask.pixmap,iconwin,NormalGC,0,0,
	    mask.attributes.width, 
	    mask.attributes.height,0,0);
E 10
E 7
  flush_expose (win);
D 7
  XCopyArea(dpy,mask.pixmap,win,NormalGC,
	    0,0,mask.attributes.width, mask.attributes.height,0,0);

E 7
I 7
D 10
  if (oldLang!=currentLang) {
    XShapeCombineMask(dpy, win, ShapeBounding, 0, 0, 
		      currentLang->mask, ShapeSet);
  }
  XCopyArea(dpy,currentLang->pixmap,win,NormalGC,0,0,
	    currentLang->attributes.width, 
	    currentLang->attributes.height,0,0);
E 10
I 10
  XCopyArea(dpy,mask.pixmap,win,NormalGC,0,0,
	    mask.attributes.width, 
	    mask.attributes.height,0,0);
E 10
  oldLang=currentLang;
E 7
}
/****************************************************************************/
void nocolor(char *a, char *b)
{
 fprintf(stderr,"cyrx: can't %s %s\n", a,b);
}
/****************************************************************************/
Pixel GetColor(char *name)
{
  XColor color;
  XWindowAttributes attributes;

  XGetWindowAttributes(dpy,Root,&attributes);
  color.pixel = 0;
   if (!XParseColor (dpy, attributes.colormap, name, &color)) 
     {
       nocolor("parse",name);
     }
   else if(!XAllocColor (dpy, attributes.colormap, &color)) 
     {
       nocolor("alloc",name);
     }
  return color.pixel;
}
E 1
