h02238
s 00003/00006/00596
d D 1.3 98/02/25 14:28:49 mini 3 2
c 
e
s 00002/00002/00600
d D 1.2 96/02/05 14:11:04 mini 2 1
c updated for gcc 2.7.0
c 
e
s 00602/00000/00000
d D 1.1 70/01/01 03:00:00 mini 1 0
c Original version
c 
e
u
U
f e 0
t
T
I 1
// This code may look like C, but this is really -*- C++ -*-

// CyrX -- pretty smart cyrillic keyboard remapper for X
//     Copyright (C) 1994  ASoft Ltd.

//     Author: Michael Nikonov 
D 2
// Time-stamp: <95/06/07 18:18:04 mini>
E 2
I 2
D 3
// Time-stamp: <February 5, 1996 13:58:30 mini>
E 3
I 3
// Time-stamp: <February 25, 1998 14:28:38 mini>
E 3
E 2

D 2
#include <stream.h>
E 2
I 2
#include <iostream.h>
E 2

extern "C" {
#include <stdio.h>

#include <X11/Xlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <xview/xview.h>
#include <xview/panel.h>

#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
}
#include "cyrmapper.h"

CyrEncoding iso_encoding[]={
#include "iso8859.h"
};

CyrEncoding koi_encoding[]={
#include "koi8.h"
};

CyrEncoding alt_encoding[]={
#include "alt.h"
};

CyrEncoding msw_encoding[]={
#include "msw.h"
};



CyrLayout cyrlayout[]={
#include "cyrl.h"
};

inline min(int a, int b) { return (a<b) ? a : b; }

int CYRSIZE=min(sizeof(iso_encoding)/(sizeof(CyrSym) + 2*sizeof(CyrCode)),
		sizeof(cyrlayout)/(2*sizeof(KeySym) + sizeof(CyrSym)));

struct Mode_Switch{   
  KeySym keysym;
  unsigned int modifier;
} mode_switches[] = {
  { XK_Shift_R, ShiftMask},
  { XK_Shift_L, ShiftMask},
  { XK_Mode_switch, AnyModifier}
  //{ XK_Control_L, ControlMask},
  //{ XK_Control_R, ControlMask}
  //{ XK_F9, AnyModifier},
  //{ XK_F10, AnyModifier}
  //{XK_Alt_L, AnyModifier}
};

int N_of_switches=sizeof(mode_switches)/sizeof(Mode_Switch);


typedef enum  {RUS=1, LAT=0} Lang;



AuxLayout auxlayout[]={
  {XK_slash, XK_question, XK_period, XK_comma},
  {XK_1, XK_exclam, XK_1, XK_exclam}
};



CyrMapper KOI("koi8", 
	      cyrlayout, 
	      auxlayout, 
	      (sizeof(auxlayout)/(4*sizeof(KeySym))),
	      koi_encoding);
	      
CyrMapper ISO("iso 8859", 
	      cyrlayout, 
	      auxlayout, 
	      (sizeof(auxlayout)/(4*sizeof(KeySym))),
	      iso_encoding);


CyrMapper MSW("MS Windows", 
	      cyrlayout, 
	      auxlayout, 
	      (sizeof(auxlayout)/(4*sizeof(KeySym))),
	      msw_encoding);
	      

CyrMapper ALT("MS DOS (alt)", 
	      cyrlayout, 
	      auxlayout, 
	      (sizeof(auxlayout)/(4*sizeof(KeySym))),
	      alt_encoding);
	      


CyrMapper *current_mapping=&ISO; 
Lang lang;

int	RUN = TRUE;

/* Time out for select. */
struct timeval timeout = { 0, 250000 };

int mode_switch;
Window root_win;
int screen;
Display	*dpy;

XEvent my_event;

Notify_value my_destroy_func(Frame frame, Destroy_status status);

Frame       frame, help_frame;
Panel       panel;
Panel_item  lang_item, mapping_item;
Server_image cyrx_image;
Server_image cyrx2_image;
Server_image cyrx_mask;
Server_image cyrx2_mask;

void SigHandler(int);
int set_rus();
int set_lat();
int toggle();

void switch_to_mapping(int id);

main(int argc, char **argv)
{

  fd_set	readfds;
  int		fd;
  int i;

  int lang_item_callback(Panel_item item, unsigned value, Event *event);
  int mapping_callback(Panel_item item, unsigned value, Event *event);
  int help_callback();

  static short cyrx_bits[] =  {
#include "cyrx.icon"
  };

  static short cyrx2_bits[] =  {
#include "cyrx2.icon"
  };

  static short cyrx_mask_bits[] =  {
#include "cyrx_mask.icon"
  };

  static short cyrx2_mask_bits[] =  {
#include "cyrx2_mask.icon"
  };

  static short cright_bits[] =  {
#include "cright.icon"
  };

  lang=LAT;


    /*
       Catch some signals so we can restore original keyboard mapping.
    */
    signal(SIGKILL, SigHandler);
    signal(SIGINT, SigHandler);
    signal(SIGTERM, SigHandler);
    signal(SIGHUP, SigHandler);


  // initializing
  xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);

  /* Some stupid XView stuff */
  frame = (Frame)xv_create((Frame)NULL, FRAME,
			   //XV_X,	10,
			   //XV_Y,	10,
			   FRAME_LABEL,	"CyrX 1.0",
			   FRAME_CLOSED, TRUE,
			   NULL);


  dpy = (Display *) XV_DISPLAY_FROM_WINDOW(frame);
  screen = DefaultScreen(dpy);
  root_win = RootWindow(dpy,screen);

  cyrx_image = (Server_image)xv_create((Frame)NULL, SERVER_IMAGE,
					 XV_WIDTH,               64,
					 XV_HEIGHT,              64,
					 //SERVER_IMAGE_DEPTH, 1,
					 SERVER_IMAGE_BITS,      cyrx_bits,
					 NULL);  

  cyrx2_image=(Server_image)xv_create((Frame)NULL, SERVER_IMAGE,
					 XV_WIDTH,               64,
					 XV_HEIGHT,              64,
					 //SERVER_IMAGE_DEPTH, 1,
					 SERVER_IMAGE_BITS,      cyrx2_bits,
					 NULL);  
  
  cyrx_mask=(Server_image)xv_create((Frame)NULL, SERVER_IMAGE,
					 XV_WIDTH,               64,
					 XV_HEIGHT,              64,
					 //SERVER_IMAGE_DEPTH, 1,
					 SERVER_IMAGE_BITS,     cyrx_mask_bits,
					 NULL);  

  cyrx2_mask=(Server_image)xv_create((Frame)NULL, SERVER_IMAGE,
					 XV_WIDTH,               64,
					 XV_HEIGHT,              64,
					 //SERVER_IMAGE_DEPTH, 1,
					 SERVER_IMAGE_BITS,    cyrx2_mask_bits,
					 NULL);  

  Icon cyrx_icon = (Icon)xv_create(frame, ICON,
			     ICON_TRANSPARENT,   TRUE,
			     ICON_IMAGE,         cyrx_image,
			     ICON_MASK_IMAGE,    cyrx_mask,
			     //XV_HEIGHT,          50,
			     XV_LABEL,           "cyrx",
			     NULL);  

 

  xv_set(frame,
	 FRAME_ICON, cyrx_icon,
	 NULL);



  panel = xv_create(frame, PANEL,
		    XV_WIDTH, 210,
		    XV_HEIGHT, 160,
		    NULL);

  lang_item=xv_create(panel, PANEL_CHOICE,
		        PANEL_LABEL_STRING, "Layout:",
			PANEL_CHOICE_STRINGS,	"Latin", "Cyrillic", NULL,
			PANEL_VALUE,		LAT,
			PANEL_NOTIFY_PROC,      lang_item_callback,
			PANEL_CLIENT_DATA,	frame,
			NULL);

  mapping_item=xv_create(panel, PANEL_CHOICE,
		         PANEL_LABEL_STRING, "Encoding:",
			 PANEL_DISPLAY_LEVEL,	PANEL_CURRENT,
			 PANEL_CHOICE_STRINGS, 
D 3
			     (char *)ISO,
E 3
I 3
			     (char *)MSW, 
E 3
			     (char *)KOI, 
I 3
			     (char *)ISO,
E 3
			     (char *)ALT,
D 3
			     (char *)MSW, 
E 3
			     NULL,
			 PANEL_VALUE,		KOI,
			 PANEL_NOTIFY_PROC,     mapping_callback,
			 PANEL_CLIENT_DATA,	frame,
			 NULL);

  xv_create(panel, PANEL_MESSAGE,
	    PANEL_LABEL_STRING, 
	    "Mode switches:",
	    XV_X, 10,
	    XV_Y, 80,
	    NULL);

  xv_create(panel, PANEL_MESSAGE,
	    PANEL_LABEL_STRING, 
"AltGraph\n\
Shift + Shift",
	    XV_X, 60,
	    XV_Y, 100,
	    NULL);


  xv_create(panel, PANEL_BUTTON,
	    XV_X, 80,
	    XV_Y, 135,
	    PANEL_LABEL_STRING, "Help...",
	    PANEL_NOTIFY_PROC,      help_callback,
	    NULL);

  help_frame=(Frame)xv_create(frame, FRAME_CMD,
			      XV_WIDTH, 500,
			      XV_HEIGHT, 300,
			      //XV_X, 200,
			      //XV_Y, 0,
			      FRAME_LABEL, "Help",
			      NULL);

  Panel help_panel=xv_get(help_frame, FRAME_CMD_PANEL); //, NULL);

  Server_image cright_image = 
    (Server_image) xv_create((Frame)NULL, SERVER_IMAGE,
			     XV_WIDTH,               128,
			     XV_HEIGHT,              128,
			     SERVER_IMAGE_BITS,      cright_bits,
			     NULL);  
  
  xv_create(help_panel, PANEL_MESSAGE,
	    PANEL_LABEL_IMAGE,  cright_image,
	    XV_X, 10,
	    XV_Y, 10,
	    NULL);

  xv_create(help_panel, PANEL_MESSAGE,
	    PANEL_LABEL_STRING, 
"         CyrX v1.0             \n\
\n\
Cyrillic Keyboard Layout Manager\n\
\n\
D 3
\n\
Copyright (c) 1995 by ASoft Ltd.\n\
\n\
E 3
Author: Mike Nikonov\n\
Original idea by: U. Savinov",
	    XV_X, 140,
	    XV_Y, 10,
	    NULL);

  xv_create(help_panel, PANEL_MESSAGE,
	    PANEL_LABEL_STRING, 
"CyrX is a keyboard layout manager for X Window System.  \n\
It works on Sun workstations (under Solaris 1.x and     \n\
Solaris 2.x) with X terminals of any type.              \n\
When killed with any of SIGINT, SIGTERM or SIGHUP       \n\
signals, CyrX restores original keyboard mapping before \n\
exiting.                                                \n\
\n\
SYNOPSIS                                                \n\
       cyrx [generic_xview_args]                        ",
	    XV_X, 10,
	    XV_Y, 170,
	    NULL);

  window_fit(help_frame);

  window_fit(frame);


  /* Interpose on the frame's destroy proc so I know when the user has
   * selected quit from the menu.  I don't want to get into a position
   * where all my windows are gone, but my main loop is still spinning
   * away.
   */
  notify_interpose_destroy_func(frame,  my_destroy_func);

  /* Something really cute: grabbing mode switches. */
  //cerr<<"N_of_switches="<< N_of_switches <<endl<<flush;

  for (i=0; i<N_of_switches; i++) {
    //cerr<<"Grabbing "<<XKeysymToString(mode_switches[i].keysym) << endl;
    //cerr<<"Keycode="<<(int)XKeysymToKeycode(dpy, mode_switches[i].keysym) ;
    //cerr <<endl<<flush;
    if (XKeysymToKeycode(dpy, mode_switches[i].keysym) != 0) {
      XGrabKey(dpy, 
	       XKeysymToKeycode(dpy, mode_switches[i].keysym),
	       mode_switches[i].modifier, 
	       root_win, False,
	       GrabModeAsync, GrabModeAsync);
    }
  }


  XSelectInput(dpy, root_win, KeyPressMask);

  switch_to_mapping(xv_get(mapping_item, PANEL_VALUE));

 
  /* Map the frame.  This is normally done for us by xv_main_loop(). */
  xv_set(frame, XV_SHOW, TRUE, 0);

  /* Get the server connection number. */
  fd = XConnectionNumber(dpy);

  /* Make sure everything gets over to the server. */
  XFlush(dpy);

  /* 
   * Create my own loop.
   */
  do {
    FD_ZERO( &readfds );
    FD_SET(fd, &readfds);

    /* Check to see if the server has written to us. */
    if (select(FD_SETSIZE, &readfds, NULL, NULL, &timeout)) {

      /* Read and dispatch grabed events in root window. */
	
      if (XCheckWindowEvent(dpy, root_win, KeyPressMask, &my_event) != False) {
	if (my_event.type==KeyPress) {
	  for (i=0; i<N_of_switches; i++) {
	    if(my_event.xkey.keycode == 
	               XKeysymToKeycode(dpy, mode_switches[i].keysym)) {
	      toggle();
	    }
	  }
	} 
      }
    
      /* Read and dispatch events for XView. */

      notify_dispatch();
      notify_dispatch(); /* Not a misprint -- do not remove this line. 
			    If you do, icon destruction will malfunction. 
			    A kind of XView magic :-) */

      /* Be sure to flush the requests
       * through to the server.
       */
      XFlush(dpy);

    } 
  } while (RUN); 

  /* All done. */
  //current_mapping->restore_lat();
#ifdef DEBUG
  printf("Going down.\n");
  fflush(stdout);
#endif DEBUG
  return 0;
}


/* This is called before the frame's destroy func (ie. I've interposed in
 * front of it).
 */
Notify_value
my_destroy_func(Notify_client client, Destroy_status status)
{
   if (status == DESTROY_PROCESS_DEATH) {
     RUN = FALSE;
     //cerr << "DESTROY_PROCESS_DEATH\n";
   } else if (status == DESTROY_CHECKING) {
     RUN = FALSE;
     //cerr << "DESTROY_CHECKING\n";
   } else if (status == DESTROY_SAVE_YOURSELF) {
     //RUN = FALSE;
     //cerr << "DESTROY_SAVE_YOURSELF\n";
   } else if (status == DESTROY_CLEANUP) {
     RUN = FALSE;
     //cerr << "DESTROY_CLEANUP\n";
   }


   if (RUN==FALSE) {
     current_mapping->restore_lat();
#ifdef DEBUG
     cerr << "Restoring original mapping.\n";
     cerr << flush;
#endif DEBUG
   }

  /* Now call the frame's destroy func. */
  notify_next_destroy_func(client, status);

  return NOTIFY_DONE;
}



int 
help_callback()
{
  xv_set(help_frame, 
	 XV_SHOW, TRUE,
	 NULL);
}



int 
lang_item_callback(Panel_item item, unsigned value, Event *event)
{
  Frame frame = xv_get(item, PANEL_CLIENT_DATA);

  if (value == RUS) {
    set_rus();
  } else if (value==LAT) { 
    set_lat();
  }
  return XV_OK;
}


int 
mapping_callback(Panel_item item, unsigned value, Event *event)
{
  Frame frame = xv_get(item, PANEL_CLIENT_DATA);
  switch_to_mapping(value);
  return XV_OK;
}


int toggle()
{
  if (lang == LAT) {
     set_rus();
  } else {
    set_lat();    
  }
  XBell(dpy, 50);
}




int set_rus()
{
  if (lang == LAT) {
    xv_set(lang_item, 
	   PANEL_VALUE, RUS, 
	   NULL);

    xv_set((Icon)xv_get(frame, FRAME_ICON),
	   ICON_TRANSPARENT,   TRUE,
	   ICON_IMAGE,         cyrx2_image,
	   ICON_MASK_IMAGE,    cyrx2_mask,
	   NULL); 

    current_mapping->set_cyr();
    lang=RUS;
  }
}



int set_lat()
{
  if (lang == RUS) {
    xv_set(lang_item, 
	   PANEL_VALUE, LAT,
 	   NULL);

    xv_set((Icon)xv_get(frame, FRAME_ICON),
	   ICON_TRANSPARENT,   TRUE,
	   ICON_IMAGE,         cyrx_image,
	   ICON_MASK_IMAGE,    cyrx_mask,
	   NULL); 

    current_mapping->restore_lat();
    lang=LAT;
  }
}


void switch_to_mapping(int id)
{
  CyrMapper *tmp;

  if (id==KOI) {
    tmp=&KOI;
  } else if (id==ISO) {
    tmp=&ISO;
  } else if (id==MSW) {
    tmp=&MSW;
  } else if (id==ALT) {
    tmp=&ALT;
  } else {
    cerr << "CyrX: bad codeset id" << endl << flush;
    tmp=&ISO;
  }
#ifdef DEBUG
  cerr << "Switching to codeset " << (char *)(*tmp);
  cerr << " lang=" << lang << endl << flush;
#endif DEBUG
  current_mapping->restore_lat();
  current_mapping=tmp;
  if (lang==RUS) current_mapping->set_cyr();

    xv_set((Icon)xv_get(frame, FRAME_ICON),
	   XV_LABEL,           (char *) *current_mapping,
	   NULL); 
}


void
SigHandler(int sig)
{
  //set_lat();
  current_mapping->restore_lat();

  cerr << "CyrX: Restoring Latin layout and exiting -- killed with signal ";
  cerr << sig << endl << flush;
  fflush(stdout);
  xv_destroy_safe(frame);
  XCloseDisplay(dpy);
  exit(0);
}
E 1
