h58583
s 00006/00009/00243
d D 1.4 98/03/14 22:43:20 mini 4 3
c 
e
s 00004/00007/00248
d D 1.3 98/03/07 22:46:18 mini 3 2
c 
e
s 00001/00001/00254
d D 1.2 98/02/25 14:53:24 mini 2 1
c 
e
s 00255/00000/00000
d D 1.1 70/01/01 03:00:00 mini 1 0
c Original version
c 
e
u
U
f e 0
t
T
I 1
// This code may look like C, but this is really -*- C++ -*-
I 3
D 4
// Time-stamp: <March 07, 1998 21:34:51 mini>
E 4
E 3

D 3
//     Copyright (C) 1994  ASoft Ltd.

//     Author: Michael Nikonov 
D 2
// Time-stamp: <95/04/25 14:50:50 mini>
E 2
I 2
// Time-stamp: <February 25, 1998 14:24:14 mini>
E 2

E 3
I 3
#include "cyrmapper.h"
E 3
D 4
#include <stream.h>
E 4
I 4
#include <stdio.h>
E 4
#include <stdlib.h>
D 3
#include "cyrmapper.h"
E 3

KeySym *CyrMapper::orig_maptab=0;
int CyrMapper::N_of_instances=0;
int CyrMapper::keysyms_per_keycode;

CyrMapper::CyrMapper(char *codeset_name, 
		     CyrLayout* cyrl, 
		     AuxLayout* auxl, 
		     int auxl_sz,
		     CyrEncoding* cyr_enc)
{
  name=codeset_name;

  layout=cyrl;

  auxlayout=auxl;
  auxl_size=auxl_sz;

  encoding = cyr_enc;



  cyr_maptab=0;
  max_cyrkey=0;
  min_cyrkey=1000;
}


CyrCode 
CyrMapper::CyrsymToCyrcode(CyrSym cyrsym)
{
  CyrCode cyrcode=NoSymbol;

  for (int i=0; i< CYRSIZE; i++) {
    if (encoding[i].cyrsym==cyrsym) cyrcode=encoding[i].cyrcode;
  }
  return cyrcode;
}


CyrCode 
CyrMapper::CyrsymToCapCyrcode(CyrSym cyrsym)
{
  CyrCode cyrcode=NoSymbol;

  for (int i=0; i< CYRSIZE; i++) {
    if (encoding[i].cyrsym==cyrsym) cyrcode=encoding[i].cap_cyrcode;
  }
  return cyrcode;
}

int 
CyrMapper::CyrsymToPlace(CyrSym cyrsym)
{
  KeySym keysym1=NoSymbol, keysym2=NoSymbol;
  int index=-1;
  int place=-1, keycode;
  int i;

  for (i=0; i< CYRSIZE; i++) {
    if (layout[i].cyrsym==cyrsym) {
      keysym1 = layout[i].keysym1;
      keysym2 = layout[i].keysym2;
      index=i;
      break;
    }
  }

  for (i=0; i<(dpy->max_keycode); i++) {
    if (orig_maptab[i*2]==keysym1 && orig_maptab[i*2+1]==keysym2) {
      place=i;
      keycode=place; // + dpy->min_keycode;
      break;
    }
  }
  if (place==-1) {
D 4
    cerr << "CyrX: don't know how to deal with this type of keyboard, exiting";
    cerr << "(error code 1)" << endl;
    cerr << "CyrSym #" << index ;
    cerr << " (mapps to " << (char) layout[index].keysym1 << ")";
    cerr << endl << flush;
E 4
I 4
    fprintf(stderr,
	    "CyrX: don't know how to deal with this type of keyboard\n"
	    "CyrSym #%d  (mapps to %c)", index, (char) layout[index].keysym1);
E 4
    exit(1);
  }
  max_cyrkey=(keycode > max_cyrkey) ? keycode : max_cyrkey;
  min_cyrkey=(keycode < min_cyrkey) ? keycode : min_cyrkey;

  return place;
} 


void
CyrMapper::X_specific_init()
{
  int i, j;

  if (orig_maptab==0) {

    //orig_maptab=new KeySym [(dpy->max_keycode - dpy->min_keycode)*2];
    orig_maptab=new KeySym [(dpy->max_keycode)*2];

    for (i=0; i<(dpy->max_keycode); i++) {
      for (j=0; j<2; j++) {
	orig_maptab[i*2+j]=XKeycodeToKeysym(dpy, i, j);;
      }
    }


  }

  if (cyr_maptab==0) {
    id = N_of_instances++; 

    cyr_maptab=new CyrCode [(dpy->max_keycode)*2];

    for (i=0; i<(dpy->max_keycode); i++) {
      for (j=0; j<2; j++) {
	cyr_maptab[i*2+j]=
	  orig_maptab[i*2+j];
      }
    }

    for (i=0; i<CYRSIZE; i++) {
      // small
      cyr_maptab[CyrsymToPlace(encoding[i].cyrsym)*2] =
	CyrsymToCyrcode(encoding[i].cyrsym);
      // cap
      cyr_maptab[CyrsymToPlace(encoding[i].cyrsym)*2+1] =
	CyrsymToCapCyrcode(encoding[i].cyrsym);
    }    

    for (int k=0; k<auxl_size; k++) {
      int found=0;

      for (i=0; i<(dpy->max_keycode); i++) {
	if (orig_maptab[i*2]==auxlayout[k].keysym1
	    && orig_maptab[i*2+1]==auxlayout[k].keysym2) {
	  cyr_maptab[i*2]=auxlayout[k].new_keysym1;
	  cyr_maptab[i*2+1]=auxlayout[k].new_keysym2;

	  max_cyrkey=(i > max_cyrkey) ? i : max_cyrkey;
	  min_cyrkey=(i < min_cyrkey) ? i : min_cyrkey;

	  found=1;
	  break;
	}	
      }
      if (found==0) {
D 4
	cerr << "CyrX: don't know how to deal with this type of keyboard,";
	cerr << "exiting (error code 2)" << endl << flush;
E 4
I 4
	fprintf(stderr, 
		"CyrX: don't know how to deal with this type of keyboard\n");
E 4
	exit(2);
      }
    }

//#ifdef NOTHING 
#ifdef DEBUG
    cout << "Codeset " << name << endl;
    cout << "CYRSIZE=" << CYRSIZE << endl;
    cout << "aux. layout size=" << auxl_size << endl;
    cout << "min code=" << dpy->min_keycode; 
    cout << " max code=" << dpy->max_keycode << endl;
    cout << "max cyrkey=" << max_cyrkey << ", min cyrkey=" << min_cyrkey;
    cout << endl;

    for (i=0; i < (dpy->max_keycode); i++) {
	//cout << dpy->min_keycode + i << "->" ;
	cout << i << "->" ;

	//orig maptab

	for (j=0; j<2; j++) {
	  cout << orig_maptab[i*2+j] << "(";
	  if ( orig_maptab[i*2+j] != NoSymbol) {
	    cout << XKeysymToString(orig_maptab[i*2+j]);
	  } else {
	    cout << "NoSym";
	  }
	  cout << ") \t";
	}

	//modified maptab

	for (j=0; j<2; j++) {
	  cout << cyr_maptab[i*2+j] << "(";
	  if ( cyr_maptab[i*2+j] != NoSymbol) {
	    cout << XKeysymToString(cyr_maptab[i*2+j]);
	  } else {
	    cout << "NoSym";
	  }
	  cout << ") (";
	  cout << (char) cyr_maptab[i*2+j];
	  cout << ") \t";
	}

	cout << endl;
      }
	cout << flush;
#endif
  }

  return;
}



void
CyrMapper::set_cyr()
{ 
#ifdef DEBUG
  cerr << " lang=CYR" << endl << flush;
#endif
D 3
   XChangeKeyboardMapping(dpy,
E 3
I 3
  X_specific_init(); 
  XChangeKeyboardMapping(dpy,
E 3
			  //dpy->min_keycode + 
			  min_cyrkey,
			  2,   //keysyms_per_keycode
			  &cyr_maptab[min_cyrkey*2],
			  (max_cyrkey-min_cyrkey)+1); 
			  //1);
}


void 
CyrMapper::restore_lat()
{
#ifdef DEBUG
  cerr << " lang=LAT" << endl << flush;
#endif
   XChangeKeyboardMapping(dpy, 
			  min_cyrkey,
			  2,
			  &orig_maptab[min_cyrkey*2],
			  (max_cyrkey-min_cyrkey)+1); 
			  //1);
}


CyrMapper::~CyrMapper()
{
  delete [] cyr_maptab;
  if (N_of_instances<0) {
    delete [] orig_maptab;
  } else  {
    --N_of_instances;
  }
}

E 1
