/* ===========================================================================
 * AScd: the AfterStep and WindowMaker CD player
 * misc.c: various stuff
 * ===========================================================================
 * Copyright (c) 1999 Denis Bourez and Rob Malda. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by Denis Bourez & Rob Malda
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY DENIS BOUREZ AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL DENIS BOUREZ, ROB MALDA OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 * ===========================================================================
 */

#include "ext.h"

/* The rc file functions, taken from xfascd*/

void load_rc_file(int mx)
{
    FILE *in;
    struct passwd *pw;
    char st[256];

    if (NULL == (pw = getpwuid(getuid()))) {
        return;
    } else {
        sprintf(st, "%s/.ascdrc", pw->pw_dir);
        if ((in = fopen(st, "r"))) {
            while ( fgets(st, 255, in) ) {
                if (strlen(st) > 0) st[strlen(st) - 1] = 0;

		if (!mx) {
#ifndef NO_D_DEVICE
		    if (strncmp(st, "CD_DEVICE=", 10) == 0) strcpy(cd_device, st + 10);
		    else if (strncmp(st, "THEME=", 6) == 0) strcpy(theme, st + 6);
		    else if (strncmp(st, "VISU=", 5) == 0) strcpy(xv, st + 5);
		    else if (strncmp(st, "AUTOREPEAT=", 11) == 0) autorepeat = atoi(st + 11);
#else
		    if (strncmp(st, "AUTOREPEAT=", 11) == 0) autorepeat = atoi(st + 11);
#endif
		    else if (strncmp(st, "AUTOPLAY=", 9) == 0) autoplay = atoi(st + 9);
		    else if (strncmp(st, "AUTOPROBE=", 10) == 0) autoprobe = atoi(st + 10);
		    else if (strncmp(st, "CUE_TIME=", 9) == 0) cue_time = atoi(st + 9);
		    else if (strncmp(st, "TI=", 3) == 0) text_timeout = atoi(st + 3);
		    else if (strncmp(st, "MAX_VOL=", 8) == 0) max_volume = atoi(st + 8);
		    else if (strncmp(st, "MIN_VOL=", 8) == 0) min_volume = atoi(st + 8);
		    else if (strncmp(st, "MUT_VOL=", 8) == 0) muted_volume = atoi(st + 8);
		    else if (strncmp(st, "VOLUME=", 7) == 0) volume = atoi(st + 7);
		    else if (strncmp(st, "FADE_STEP=", 10) == 0) fade_step = atoi(st + 10);
		    else if (strncmp(st, "TIMEMODE=", 9) == 0) time_mode = atoi(st + 9);
		    else if (strcmp(st, "WITHDRAWN") == 0) withdrawn = TRUE;
		    else if (strcmp(st, "SHOWDB") == 0) show_db = TRUE;
		    else if (strcmp(st, "SHOWARTIST") == 0) show_artist = TRUE;
		    else if (strcmp(st, "UPPERCASE") == 0) force_upper = TRUE;
		    else if (strncmp(st, "IGNORE_AVOID=", 13) == 0) ignore_avoid = atoi(st + 13);
		}
            }
            fclose(in);
            return;
        } else {
            return;
        }
    }
}

void save_rc_file()
{
    FILE *out;
    struct passwd *pw;
    char st[128];

    if (NULL == (pw = getpwuid(getuid()))) {
	/* hum... big problem... */
        return;
    } else {
        sprintf(st, "%s/.ascdrc", pw->pw_dir);
        if ((out = fopen(st, "w"))) {
            fprintf(out, "#### generated by AScd version %s ####\n", VERSION);
#ifndef NO_D_DEVICE
	    fprintf(out, "CD_DEVICE=%s\n", cd_device);
#endif	   
	    fprintf(out, "THEME=%s\n", theme);
	    fprintf(out, "VISU=%s\n", xv);
            fprintf(out, "AUTOREPEAT=%d\n", autorepeat);
            fprintf(out, "AUTOPLAY=%d\n", autoplay);
            fprintf(out, "AUTOPROBE=%d\n", autoprobe);
            fprintf(out, "CUE_TIME=%d\n", cue_time);
            fprintf(out, "TI=%d\n", text_timeout);
            fprintf(out, "VOLUME=%d\n", volume);
            fprintf(out, "MAX_VOL=%d\n", max_volume);
            fprintf(out, "MIN_VOL=%d\n", min_volume);
            fprintf(out, "MUT_VOL=%d\n", muted_volume);
            fprintf(out, "FADE_STEP=%d\n", fade_step);
	    fprintf(out, "TIMEMODE=%d\n", time_mode);
            fprintf(out, "IGNORE_AVOID=%d\n", ignore_avoid);
	    if (withdrawn) {
		fprintf(out, "WITHDRAWN\n");
	    }
	    if (show_db) {
		fprintf(out, "SHOWDB\n");
	    }
	    if (show_artist) {
		fprintf(out, "SHOWARTIST\n");
	    }
	    if (force_upper) {
		fprintf(out, "UPPERCASE\n");
	    }

            fclose(out);
            return;
        } else {
            return;
        }
    }
}

void command_line_help() 
{
    fprintf(stderr, "ascd %s ", VERSION);
#ifdef WMK
    fprintf(stderr, "[WINGs] ");
#endif
#ifdef MIXER
    fprintf(stderr, "[mixer] ");
#endif
    fprintf(stderr, "\n(c) 1999 Rob Malda and Denis Bourez\n");
    fprintf(stderr, "Usage:  ascd [-options ...] where the options are:\n\n");

    fprintf(stderr, "-version                 Display the version numbers and exit\n");
    fprintf(stderr, "-help                    Display this help screen and exit\n");
    fprintf(stderr, "-themes                  Display available themes and exit\n\n");

    fprintf(stderr, "+/-withdrawn             Turn on/off withdrawn mode for WindowMaker\n");
    fprintf(stderr, "-geometry geom           Standard X Location\n");
    fprintf(stderr, "-ti time                 Texts display timeout in seconds (default = 1)\n");
    fprintf(stderr, "-cue time                Cue Time in seconds (default = 10)\n");
    fprintf(stderr, "+/-a                     Turn on/off Autoplay mode\n");
    fprintf(stderr, "+/-p                     Turn on/off Autoprobe mode\n");
    fprintf(stderr, "+/-t                     Turn on/off Autorepeat mode\n");
    fprintf(stderr, "+/-B                     Turn on/off Blind mode (no counters updates)\n");
    fprintf(stderr, "+/-ia                    Apply/Ignore 'avoid' tags in WorkMan database\n"),
    fprintf(stderr, "+/-up                    All messages in uppercase?\n");
    fprintf(stderr, "-theme value             Select the visual theme (in %s)\n", THDIR);
    fprintf(stderr, "-xf                      Launch XfAscd with middle click on counter\n");
    fprintf(stderr, "-minvolume value         Minimum volume\n");
    fprintf(stderr, "-maxvolume value         Maximum volume\n");
    fprintf(stderr, "-volume value            CD Drive volume, from 0 to maxvolume\n");
    fprintf(stderr, "-mvolume value           CD Drive volume in mute mode, from 0 to maxvolume\n");
    fprintf(stderr, "-fadestep value          Fade in/out timing offset\n");
    fprintf(stderr, "-device device_driver    CDROM drive device\n");
#ifdef MIXER
    fprintf(stderr, "-mixer device_driver     Mixer device\n");
#endif
    fprintf(stderr, "-showtitle               Turn on Song Title Scrolling\n");
    fprintf(stderr, "-showartist              Show artist name when scrolling song title\n");
    fprintf(stderr, "-debug                   Enable debug (verbose) messages on stderr\n");
    fprintf(stderr, "-save                    Save settings and exit. Should be *last* command.\n\n");
    exit(0);
} 

void command_line_err() 
{
    fprintf(stderr, "ascd: bad command line syntax.\n");
    fprintf(stderr, "Type 'ascd -help' for a list of command line options.\n");
    exit(-1);
} 

void themes_help()
{
    char txt[256];
    char key[256];
    char r[256];
    char d[256];
    char arguments[256];
    DIR *dir_fd;
    struct dirent *dir_pt;
    FILE *in;

    fprintf(stderr, "List of AScd installed themes:\n\n");

    fprintf(stderr, "Theme            Release      Description\n");
    fprintf(stderr, "---------------- ------------ -------------------------------------\n");

    sprintf(txt, "%s/Themes", THDIR);
    if ((dir_fd = opendir(txt)) != NULL) {
	while((dir_pt = readdir(dir_fd)) != NULL) {
	    if (dir_pt->d_name[0] != '.') {
		fprintf(stderr, "%-16s ", dir_pt->d_name);
		sprintf(txt, "%s/Themes/%s/Theme", THDIR, dir_pt->d_name);
		if (access(txt, R_OK) == 0) {
		    if (!(in = fopen(txt, "r"))) {
			fprintf(stderr, "cannot open Theme definition file");
		    } else {
			strcpy(d, "");
			strcpy(r, "");
			while (tes_xgets(txt, 256, in)) {
			    fak_parse_line(txt, key, arguments);
			    if (strcmp(key, "release") == 0) strcpy(r, arguments);
			    if (strcmp(key, "name") == 0) strcpy(d, arguments);
			}
			fprintf(stderr, "%-12s %s", r, d);
			fclose(in);
		    }
		} else {
		    fprintf(stderr, "cannot find Theme definition file");
		}
		fprintf(stderr, "\n");
	    }
	}
	closedir(dir_fd);
    } else {
	fprintf(stderr, "Can't read directory %s!\n", txt);
    }
    fprintf(stderr, "\n");

    exit(0);
}

#define MAX_LINE_NAME 16

void command_line_parse(int argc, char *argv[]) {
    int i;
    char *Argument;
    int sw;

    for (i = 1 ; i < argc ; i++) {
	Argument = argv[i];

	if ((Argument[0] == '-') || (Argument[0] == '+')) {
	    if (Argument[0] == '-') {
		sw = FALSE;
	    } else if (Argument[0] == '+') {
		sw = TRUE;
	    }

	    if ((strcmp(Argument + 1, "w") == 0) || (strcmp(Argument + 1, "withdrawn") == 0)) {
		if (sw) withdrawn = TRUE;
		else withdrawn = FALSE;
	    }

	    else if ((strcmp(Argument + 1, "g") == 0) || (strcmp(Argument + 1, "geometry") == 0)) {
		if(++i >= argc) command_line_err();
		Geometry = argv[i];
	    }
	    
	    else if ((strcmp(Argument + 1, "d") == 0) || (strcmp(Argument + 1, "device") == 0)) {
		if(++i >= argc) command_line_err();
		cd_device = malloc(strlen(argv[i]) + 1);
		strcpy(cd_device, argv[i]);
	    }

#ifdef MIXER
	    else if (strcmp(Argument + 1, "mixer") == 0) {
		if(++i >= argc) command_line_err();
		strcpy(mixer_device, argv[i]);
	    }
#endif

	    else if (strcmp(Argument + 1, "theme") == 0) {
		if(++i >= argc) command_line_err();
		strcpy(theme, argv[i]);
	    }

	    else if ((strcmp(Argument + 1, "c") == 0) || (strcmp(Argument + 1, "cue") == 0)) {
		if(++i >= argc) command_line_err();
		cue_time = atoi(argv[i]);
	    }

	    else if ((strcmp(Argument + 1, "i") == 0) || (strcmp(Argument + 1, "ti") == 0)) {
		if(++i >= argc) command_line_err();
		text_timeout = atoi(argv[i]);
	    }

	    else if ((strcmp(Argument + 1, "a") == 0) || (strcmp(Argument + 1, "autoplay") == 0)) {
		if (sw) autoplay = TRUE;
		else autoplay = FALSE;
	    }

	    else if ((strcmp(Argument + 1, "p") == 0) || (strcmp(Argument + 1, "autoprobe") == 0)) {
		if (sw) autoprobe = TRUE;
		else autoprobe = FALSE;
	    }

	    else if (strcmp(Argument + 1, "B") == 0) {
		if (sw) blind_mode = TRUE;
		else blind_mode = FALSE;
	    }

	    else if (strcmp(Argument + 1, "ia") == 0) {
		if (sw) ignore_avoid = TRUE;
		else ignore_avoid = FALSE;
	    }

	    else if (strcmp(Argument + 1, "up") == 0) {
		if (sw) force_upper = TRUE;
		else force_upper = FALSE;
	    }

	    else if ((strcmp(Argument + 1, "t") == 0) || (strcmp(Argument + 1, "autorepeat") == 0)) {
		if (sw) autorepeat = TRUE;
		else autorepeat = FALSE;
	    }

	    else if (strcmp(Argument + 1, "showtitle") == 0) {
		show_db = TRUE;
	    }

	    else if (strcmp(Argument + 1, "showartist") == 0) {
		show_artist = TRUE;
	    }

	    else if (strcmp(Argument + 1, "debug") == 0) {
	        debug++;
	    }

	    else if (strcmp(Argument + 1, "mvolume") == 0) {
		if(++i >= argc) command_line_err();
		muted_volume = atoi(argv[i]);
	    }

	    else if (strcmp(Argument + 1, "volume") == 0) {
		if(++i >= argc) command_line_err();
		volume = atoi(argv[i]);
	    }

	    else if (strcmp(Argument + 1, "xf") == 0) {
		xflaunch = TRUE;
	    }


	    else if (strcmp(Argument + 1, "maxvolume") == 0) {
		if(++i >= argc) command_line_err();
		max_volume = atoi(argv[i]);
	    }

	    else if (strcmp(Argument + 1, "minvolume") == 0) {
		if(++i >= argc) command_line_err();
		min_volume = atoi(argv[i]);
	    }

	    else if (strcmp(Argument + 1, "fadestep") == 0) {
		if(++i >= argc) command_line_err();
		fade_step = atoi(argv[i]);
	    }

	    else if (strcmp(Argument + 1, "save") == 0) {
		save_rc_file();
		fprintf(stderr, "Settings file saved.\n");
		exit(0);
	    }

	    else if ((strcmp(Argument + 1, "version") == 0) || (strcmp(Argument + 1, "v") == 0)) {
		fprintf(stderr, "%s %s (CDcontrol %s, %s)\n", PACKAGE, VERSION, cd_control_version(), wm_libver_string());
		exit(0);
	    }

	    else if (strcmp(Argument + 1, "themes") == 0) {
		themes_help();
	    }

	    else if ((strcmp(Argument + 1, "h") == 0) || (strcmp(Argument + 1, "help") == 0)) {
		command_line_help();
	    } else {
		command_line_err();
	    }
	} else {
	    command_line_err();
	}

    }
    
} 

void quick_reference(int nbr)
{
    char txt[127];
    char fic[40];

    if (nbr == 0) strcpy(fic, "quick*");
    else sprintf(fic, "quick%d.gif", nbr);

    sprintf(txt, "%s/Themes/%s/quick", THDIR, theme);
    if (access(txt, R_OK) == 0) {
	sprintf(txt, "%s %s/Themes/%s/quick/%s &", xv, THDIR, theme, fic);
	system(txt);
    }
}

/* ------------------------------------------------------------------------
   dumb functions: do nothing, but they need to be present if we don't
   wanna change anything in the WorkMan code...
   ------------------------------------------------------------------------ */

void disable_save() { }
int get_playnew() { return autoplay; }
void set_abtimer(int a, int b) { }
void about_set_drivetype(char *vendor, char *model, char *rev) { }
